/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public abstract class PreviewOptionsScreen
extends BaseOptionsScreen {
    private boolean adjustingPosition;
    private boolean adjustDragging;
    private double dragOffsetX;
    private double dragOffsetY;

    public PreviewOptionsScreen(Screen parent, Component title) {
        super(parent, title);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAdjustingPosition() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof PreviewOptionsScreen)) return false;
        PreviewOptionsScreen screen2 = (PreviewOptionsScreen)screen;
        if (!screen2.adjustingPosition) return false;
        return true;
    }

    private static float calculateAnchor(float center, float size, float rectSize) {
        float anchor = center / size;
        if (anchor < 0.25f) {
            return 0.0f;
        }
        if (anchor > 0.75f) {
            return 1.0f;
        }
        float halfRectSize = rectSize / 2.0f;
        float tolerance = Math.min(15.0f, halfRectSize / 2.0f - 3.0f);
        if (Math.abs(center + halfRectSize - size / 2.0f) < tolerance) {
            return 1.0f;
        }
        if (Math.abs(center - halfRectSize - size / 2.0f) < tolerance) {
            return 0.0f;
        }
        return 0.5f;
    }

    private static float maybeSnap(float value) {
        if (!Screen.hasControlDown() && value > 0.475f && value < 0.525f) {
            return 0.5f;
        }
        return value;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.minecraft);
        super.init();
        if (this.minecraft.level != null) {
            CycleButton previewButton = CycleButton.booleanBuilder((Component)OptionsList.OPTION_ON, (Component)OptionsList.OPTION_OFF).create(10, this.saveButton.getY(), 85, 20, (Component)Component.translatable((String)"gui.jade.preview"), (button, value) -> {
                Jade.history().previewOverlay = value;
                this.saver.run();
            });
            previewButton.setValue((Object)Jade.history().previewOverlay);
            this.addRenderableWidget((GuiEventListener)previewButton);
        }
    }

    public boolean forcePreviewOverlay() {
        Objects.requireNonNull(this.minecraft);
        if (this.adjustingPosition) {
            return true;
        }
        if (!this.isDragging() || this.options == null) {
            return false;
        }
        OptionsList.Entry entry = (OptionsList.Entry)this.options.getSelected();
        if (entry == null || entry.getFirstWidget() == null) {
            return false;
        }
        return this.options.forcePreview.contains((Object)entry);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_94697_) {
        if (!this.adjustingPosition) {
            return super.mouseClicked(mouseX, mouseY, p_94697_);
        }
        Objects.requireNonNull(this.minecraft);
        Rect2f rect = OverlayRenderer.animation.expectedRect;
        if (rect.contains((int)mouseX, (int)mouseY)) {
            this.setDragging(true);
            this.adjustDragging = true;
            float centerX = rect.getX() + rect.getWidth() / 2.0f;
            float centerY = rect.getY() + rect.getHeight() / 2.0f;
            this.dragOffsetX = mouseX - (double)centerX;
            this.dragOffsetY = mouseY - (double)centerY;
        } else {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            int xIndex = Mth.clamp((int)((int)(mouseX / ((double)this.width / 3.0))), (int)0, (int)2);
            int yIndex = Mth.clamp((int)((int)(mouseY / ((double)this.height / 3.0))), (int)0, (int)2);
            if (xIndex == 1 && yIndex == 1) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
            } else {
                IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
                overlay.setOverlayPosX(IWailaConfig.get().accessibility().tryFlip((float)xIndex / 2.0f));
                overlay.setOverlayPosY(1.0f - (float)yIndex / 2.0f);
                overlay.setAnchorX(IWailaConfig.get().accessibility().tryFlip((float)xIndex / 2.0f));
                overlay.setAnchorY((float)yIndex / 2.0f);
            }
        }
        return true;
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.adjustingPosition) {
            this.setDragging(false);
            this.adjustDragging = false;
            return true;
        }
        return super.mouseReleased(d, e, i);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public boolean keyReleased(int i, int j, int k) {
        Objects.requireNonNull(this.minecraft);
        if (this.adjustingPosition) {
            if (i == 256) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        return super.keyReleased(i, j, k);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.adjustingPosition && this.adjustDragging) {
            float centerX = (float)d - (float)this.dragOffsetX;
            float centerY = (float)e - (float)this.dragOffsetY;
            Rect2f rect = OverlayRenderer.animation.expectedRect;
            float rectWidth = rect.getWidth();
            float rectHeight = rect.getHeight();
            float anchorX = PreviewOptionsScreen.calculateAnchor(centerX, this.width, rectWidth);
            float anchorY = PreviewOptionsScreen.calculateAnchor(centerY, this.height, rectHeight);
            float posX = (centerX + rectWidth * (anchorX - 0.5f)) / (float)this.width;
            float posY = 1.0f - (centerY + rectHeight * (anchorY - 0.5f)) / (float)this.height;
            IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
            IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
            overlay.setOverlayPosX(accessibility.tryFlip(PreviewOptionsScreen.maybeSnap(posX)));
            overlay.setOverlayPosY(PreviewOptionsScreen.maybeSnap(posY));
            overlay.setAnchorX(accessibility.tryFlip(anchorX));
            overlay.setAnchorY(anchorY);
            return true;
        }
        return super.mouseDragged(d, e, i, f, g);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.adjustingPosition) {
            super.render(guiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
            guiGraphics.fill(0, 0, this.width, this.height, -2139062144);
            MutableComponent text = Component.translatable((String)"config.jade.overlay_pos.exit");
            Font font = DisplayHelper.font();
            int textWidth = font.width((FormattedText)text);
            int x = (this.width - textWidth) / 2;
            int y = this.height / 2 - 7;
            Objects.requireNonNull(font);
            guiGraphics.fill(x - 4, y - 4, x + textWidth + 4, y + 9 + 4, -2013265920);
            guiGraphics.drawString(font, (Component)text, x, y, -1);
            IWailaConfig.Overlay config = IWailaConfig.get().overlay();
            Rect2f rect = OverlayRenderer.animation.expectedRect;
            if (IWailaConfig.get().general().isDebug()) {
                int anchorX = (int)(rect.getX() + rect.getWidth() * config.getAnchorX());
                int anchorY = (int)(rect.getY() + rect.getHeight() * config.getAnchorY());
                guiGraphics.fill(anchorX - 2, anchorY - 2, anchorX + 1, anchorY + 1, -65536);
            }
            if (config.getOverlayPosX() == 0.5f) {
                guiGraphics.fill(this.width / 2, (int)(rect.getY() - 5.0f), this.width / 2 + 1, (int)(rect.getY() + rect.getHeight() + 4.0f), -16776961);
            }
            if (config.getOverlayPosY() == 0.5f) {
                guiGraphics.fill((int)(rect.getX() - 5.0f), this.height / 2, (int)(rect.getX() + rect.getWidth() + 4.0f), this.height / 2 + 1, -16776961);
            }
        } else {
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void startAdjustingPosition() {
        this.adjustingPosition = true;
    }

    protected void updateNarratedWidget(NarrationElementOutput narrationElementOutput) {
        if (this.adjustingPosition) {
            narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.jade.adjusting_position"));
            return;
        }
        super.updateNarratedWidget(narrationElementOutput);
    }

    protected boolean shouldNarrateNavigation() {
        return !this.adjustingPosition;
    }
}

