/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.util.SmoothChasingValue;

public class CreditButton
extends Button {
    private final Component hoveredTitle;
    private final Button.OnPress onHover;
    private final SmoothChasingValue progress = new SmoothChasingValue();
    private boolean oldHovered;
    private boolean showTranslators;
    private List<String> translators = List.of();
    private int translatorIndex;
    private float translatorTime;

    protected CreditButton(int x, int y, int width, int height, Component title, Component hoveredTitle, Button.OnPress onPress, Button.OnPress onHover, Button.CreateNarration createNarration) {
        super(x, y, width, height, title, onPress, createNarration);
        this.hoveredTitle = hoveredTitle;
        this.onHover = onHover;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float partialTicks) {
        float alpha;
        boolean hovered = this.isHoveredOrFocused();
        if (!this.oldHovered && hovered) {
            this.progress.target(1.0f);
        } else if (!hovered) {
            this.progress.target(0.0f);
        } else if (this.progress.value > 0.5f) {
            this.progress.target(0.0f);
            this.onHover.onPress((Button)this);
        }
        this.progress.tick(partialTicks);
        this.progress.value = Math.min(0.6f, this.progress.value);
        float f = alpha = hovered ? 170.0f : 85.0f;
        if (this.showTranslators && !this.translators.isEmpty()) {
            int cycleTime = 60;
            this.translatorTime += partialTicks;
            if (this.translatorTime > (float)cycleTime) {
                this.nextTranslator();
            }
            if (!hovered && this.translators.size() > 1) {
                if (this.translatorTime < 5.0f) {
                    alpha *= this.translatorTime / 5.0f;
                } else if ((float)cycleTime - this.translatorTime < 5.0f) {
                    alpha *= ((float)cycleTime - this.translatorTime) / 5.0f;
                }
                alpha = Math.max(alpha, 17.0f);
            }
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX() + (float)this.width * 0.5f, (float)this.getY());
        float scale = 1.0f + this.progress.value * 0.2f;
        guiGraphics.pose().scale(scale);
        Component credit = hovered ? this.hoveredTitle : this.getMessage();
        Font font = Minecraft.getInstance().font;
        guiGraphics.pose().translate((float)font.width((FormattedText)credit) * -0.5f, 0.0f);
        guiGraphics.drawString(font, credit, 0, 0, 0xFFFFFF | (int)alpha << 24);
        guiGraphics.pose().popMatrix();
        this.oldHovered = hovered;
    }

    public void showTranslators() {
        if (this.showTranslators) {
            return;
        }
        this.showTranslators = true;
        if (!I18n.exists((String)"gui.jade.translators") || "placeholder ".equals(I18n.get((String)"gui.jade.translated_by", (Object[])new Object[]{""}))) {
            return;
        }
        String s = I18n.get((String)"gui.jade.translators", (Object[])new Object[0]);
        if ("Bob, Alice, Charlie".equals(s)) {
            return;
        }
        this.translators = Stream.of(StringUtils.split((String)s, (char)',')).map(String::trim).filter(StringUtils::isNotEmpty).toList();
        if (this.translators.size() > 1) {
            this.translatorIndex = RandomSource.create().nextInt(this.translators.size());
        }
        this.nextTranslator();
    }

    private void nextTranslator() {
        this.setMessage((Component)Component.translatable((String)"gui.jade.translated_by", (Object[])new Object[]{this.translators.get(this.translatorIndex)}));
        if (this.translators.size() <= 1) {
            return;
        }
        ++this.translatorIndex;
        if (this.translatorIndex >= this.translators.size()) {
            this.translatorIndex = 0;
        }
        this.translatorTime = 0.0f;
    }
}

