/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.Accessor;

public abstract class AccessorImpl<T extends HitResult>
implements Accessor<T> {
    private final Level level;
    private final Player player;
    private final CompoundTag serverData;
    private final Supplier<T> hit;
    private final boolean serverConnected;
    private final boolean showDetails;
    protected boolean verify;
    private RegistryFriendlyByteBuf buffer;

    public AccessorImpl(Level level, Player player, CompoundTag serverData, Supplier<T> hit, boolean serverConnected, boolean showDetails) {
        this.level = level;
        this.player = player;
        this.hit = hit;
        this.serverConnected = serverConnected;
        this.showDetails = showDetails;
        this.serverData = serverData == null ? new CompoundTag() : serverData.copy();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public final CompoundTag getServerData() {
        return this.serverData;
    }

    private RegistryFriendlyByteBuf buffer() {
        if (this.buffer == null) {
            this.buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.level.registryAccess());
        }
        this.buffer.clear();
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <D> Optional<D> decodeFromNbt(StreamDecoder<RegistryFriendlyByteBuf, D> codec, Tag tag) {
        try {
            RegistryFriendlyByteBuf buffer = this.buffer();
            buffer.writeBytes(((ByteArrayTag)tag).getAsByteArray());
            Object decoded = codec.decode((Object)buffer);
            Optional<Object> optional = Optional.of(decoded);
            return optional;
        }
        catch (Exception e) {
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public <D> Tag encodeAsNbt(StreamEncoder<RegistryFriendlyByteBuf, D> streamCodec, D value) {
        RegistryFriendlyByteBuf buffer = this.buffer();
        streamCodec.encode((Object)buffer, value);
        ByteArrayTag tag = new ByteArrayTag(ArrayUtils.subarray((byte[])buffer.array(), (int)0, (int)buffer.readableBytes()));
        buffer.clear();
        return tag;
    }

    @Override
    public T getHitResult() {
        return (T)((HitResult)this.hit.get());
    }

    @Override
    public boolean isServerConnected() {
        return this.serverConnected;
    }

    @Override
    public boolean showDetails() {
        return this.showDetails;
    }

    @Override
    public abstract ItemStack getPickedResult();

    public void requireVerification() {
        this.verify = true;
    }

    @Override
    public float tickRate() {
        return this.getLevel().tickRateManager().tickrate();
    }
}

