/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.ui.CompoundElement;

public class WaxedProvider
implements IBlockComponentProvider {
    public static final WaxedProvider INSTANCE = new WaxedProvider();

    @Override
    @Nullable
    public Element getIcon(BlockAccessor accessor, IPluginConfig config, Element currentIcon) {
        if (accessor.getPickedResult().isEmpty()) {
            return currentIcon;
        }
        Element largeIcon = JadeUI.item(accessor.getPickedResult());
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            if (sign.isWaxed()) {
                return new CompoundElement(largeIcon, JadeUI.item(Items.HONEYCOMB.getDefaultInstance(), 0.5f));
            }
            return largeIcon;
        }
        return currentIcon;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        String message;
        SignBlockEntity sign;
        BlockEntity blockEntity;
        if (IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && (blockEntity = accessor.getBlockEntity()) instanceof SignBlockEntity && (sign = (SignBlockEntity)blockEntity).isWaxed() && !(message = tooltip.getString(JadeIds.CORE_OBJECT_NAME)).isBlank()) {
            tooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)IThemeHelper.get().title(Component.translatable((String)"jade.waxed", (Object[])new Object[]{message})));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_WAXED;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.ForBlock.INSTANCE.getDefaultPriority() + 10;
    }
}

