/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.frog.Tadpole;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public class MobGrowthProvider
implements StreamServerDataProvider<EntityAccessor, Integer> {
    public static final MobGrowthProvider INSTANCE = new MobGrowthProvider();

    @Override
    @Nullable
    public Integer streamData(EntityAccessor accessor) {
        int time = -1;
        Entity entity = accessor.getEntity();
        if (entity instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)entity;
            time = -ageable.getAge();
        } else if (entity instanceof Tadpole) {
            Tadpole tadpole = (Tadpole)entity;
            time = tadpole.getTicksLeftUntilAdult();
        }
        return time > 0 ? Integer.valueOf(time) : null;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Integer> streamCodec() {
        return ByteBufCodecs.VAR_INT.cast();
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_MOB_GROWTH;
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            int time = INSTANCE.decodeFromData(accessor).orElse(0);
            if (time > 0) {
                tooltip.add((Component)Component.translatable((String)"jade.mobgrowth.time", (Object[])new Object[]{IThemeHelper.get().seconds(time, accessor.tickRate())}));
            }
        }

        @Override
        public ResourceLocation getUid() {
            return JadeIds.MC_MOB_GROWTH;
        }
    }
}

