/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.OwnableEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.CommonProxy;

public class AnimalOwnerProvider
implements StreamServerDataProvider<EntityAccessor, String> {
    public static final AnimalOwnerProvider INSTANCE = new AnimalOwnerProvider();

    @Override
    public String streamData(EntityAccessor accessor) {
        return CommonProxy.getLastKnownUsername(AnimalOwnerProvider.getOwnerUUID(accessor.getEntity()));
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, String> streamCodec() {
        return ByteBufCodecs.STRING_UTF8.cast();
    }

    public static UUID getOwnerUUID(Entity entity) {
        OwnableEntity ownableEntity;
        EntityReference reference;
        if (entity instanceof OwnableEntity && (reference = (ownableEntity = (OwnableEntity)entity).getOwnerReference()) != null) {
            return reference.getUUID();
        }
        return null;
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        return entity instanceof OwnableEntity && AnimalOwnerProvider.getOwnerUUID(entity) == null;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_ANIMAL_OWNER;
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            String name = INSTANCE.decodeFromData(accessor).orElse("");
            if (name.isEmpty()) {
                UUID ownerUUID = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
                if (ownerUUID == null) {
                    return;
                }
                name = CommonProxy.getLastKnownUsername(ownerUUID);
                if (name == null) {
                    name = "???";
                }
            }
            tooltip.add((Component)Component.translatable((String)"jade.owner", (Object[])new Object[]{name}));
        }

        @Override
        public ResourceLocation getUid() {
            return JadeIds.MC_ANIMAL_OWNER;
        }
    }
}

