/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.mixin.EntityAccess;

public abstract class ObjectNameProvider
implements IToggleableProvider {
    @Override
    public ResourceLocation getUid() {
        return JadeIds.CORE_OBJECT_NAME;
    }

    @Override
    public int getDefaultPriority() {
        return -10100;
    }

    public static class Server
    extends ObjectNameProvider
    implements StreamServerDataProvider<BlockAccessor, Component> {
        public static final Server INSTANCE = new Server();

        @Override
        @Nullable
        public Component streamData(BlockAccessor accessor) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (!(blockEntity instanceof Nameable)) {
                return null;
            }
            Nameable nameable = (Nameable)blockEntity;
            if (nameable instanceof ChestBlockEntity && accessor.getBlock() instanceof ChestBlock && accessor.getBlockState().getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                TranslatableContents contents;
                Component name;
                ComponentContents componentContents;
                MenuProvider menuProvider = accessor.getBlockState().getMenuProvider(accessor.getLevel(), accessor.getPosition());
                if (!(menuProvider == null || (componentContents = (name = menuProvider.getDisplayName()).getContents()) instanceof TranslatableContents && "container.chestDouble".equals((contents = (TranslatableContents)componentContents).getKey()))) {
                    return name;
                }
            } else if (nameable.hasCustomName()) {
                return nameable.getDisplayName();
            }
            return (Component)accessor.getBlockEntity().components().get(DataComponents.ITEM_NAME);
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Component> streamCodec() {
            return ComponentSerialization.STREAM_CODEC;
        }

        @Override
        public boolean shouldRequestData(BlockAccessor accessor) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity == null) {
                return false;
            }
            return blockEntity instanceof Nameable || blockEntity.components().has(DataComponents.ITEM_NAME);
        }
    }

    public static class ForEntity
    extends ObjectNameProvider
    implements IEntityComponentProvider {
        public static final ForEntity INSTANCE = new ForEntity();

        public static Component getEntityName(Entity entity, boolean accessibilityDetails) {
            ItemStack stack;
            Component customName = entity.getCustomName();
            if (customName != null && !accessibilityDetails) {
                return customName;
            }
            Component displayName = null;
            boolean wantTypeName = accessibilityDetails;
            if (WailaClientRegistration.instance().shouldPick(entity) && (stack = entity.getPickResult()) != null && !stack.isEmpty()) {
                displayName = stack.getHoverName();
            }
            if (displayName == null) {
                Component component;
                Entity entity2 = entity;
                Objects.requireNonNull(entity2);
                stack = entity2;
                int n = 0;
                block7: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, Villager.class, ItemEntity.class, Display.ItemDisplay.class, Display.BlockDisplay.class}, (Object)stack, n)) {
                        case 0: {
                            Player ignored = (Player)stack;
                            wantTypeName = false;
                            component = entity.getDisplayName();
                            break block7;
                        }
                        case 1: {
                            Villager ignored = (Villager)stack;
                            wantTypeName = false;
                            component = entity.getType().getDescription();
                            break block7;
                        }
                        case 2: {
                            ItemEntity itemEntity = (ItemEntity)stack;
                            component = itemEntity.getItem().getHoverName();
                            break block7;
                        }
                        case 3: {
                            Display.ItemDisplay itemDisplay = (Display.ItemDisplay)stack;
                            if (itemDisplay.getSlot(0).get().isEmpty()) {
                                n = 4;
                                continue block7;
                            }
                            component = itemDisplay.getSlot(0).get().getHoverName();
                            break block7;
                        }
                        case 4: {
                            Display.BlockDisplay blockDisplay = (Display.BlockDisplay)stack;
                            if (blockDisplay.getBlockState().isAir()) {
                                n = 5;
                                continue block7;
                            }
                            component = blockDisplay.getBlockState().getBlock().getName();
                            break block7;
                        }
                        default: {
                            component = entity.getName();
                            break block7;
                        }
                    }
                    break;
                }
                displayName = component;
            }
            Objects.requireNonNull(displayName);
            if (accessibilityDetails) {
                if (customName != null && displayName.getString().equals(customName.getString())) {
                    displayName = customName;
                    customName = null;
                }
                if (wantTypeName) {
                    Component typeName = ((EntityAccess)entity).callGetTypeName();
                    if (!displayName.getString().equals(typeName.getString())) {
                        displayName = Component.translatable((String)"jade.typeNameEntity", (Object[])new Object[]{displayName, typeName});
                    }
                }
                if (customName != null) {
                    return Component.translatable((String)"jade.customNameEntity", (Object[])new Object[]{customName, displayName});
                }
            }
            return displayName;
        }

        public static void addName(ITooltip tooltip, Component name) {
            Element newIcon;
            name = IThemeHelper.get().title(name);
            if (IWailaConfig.get().overlay().getIconMode() != IWailaConfig.IconMode.INLINE) {
                tooltip.add(name);
                return;
            }
            Element icon = tooltip.getIcon();
            if (icon instanceof ItemStackElement) {
                ItemStackElement itemStackElement = (ItemStackElement)icon;
                newIcon = JadeUI.smallItem(itemStackElement.getItem());
            } else {
                newIcon = null;
            }
            if (newIcon == null) {
                tooltip.add(name);
                return;
            }
            tooltip.add(newIcon.tag(JadeIds.CORE_ROOT_ICON));
            tooltip.append(name);
        }

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            Component name = ForEntity.getEntityName(accessor.getEntity(), IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && config.get(JadeIds.ACCESS_ENTITY_DETAILS));
            ForEntity.addName(tooltip, name);
        }
    }

    public static class ForBlock
    extends ObjectNameProvider
    implements IBlockComponentProvider {
        public static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ItemStack pick;
            Object name = Server.INSTANCE.decodeFromData(accessor).orElse(null);
            if (name == null && accessor.isFakeBlock()) {
                name = accessor.getFakeBlock().getHoverName();
            }
            if (name == null && WailaClientRegistration.instance().shouldPick(accessor.getBlockState()) && (pick = accessor.getPickedResult()) != null && !pick.isEmpty()) {
                name = pick.getHoverName();
            }
            if (name == null) {
                ItemStack pick2;
                String key = accessor.getBlock().getDescriptionId();
                name = I18n.exists((String)key) ? accessor.getBlock().getName() : ((pick2 = accessor.getPickedResult()) != null && !pick2.isEmpty() ? pick2.getHoverName() : Component.literal((String)key));
            }
            ForEntity.addName(tooltip, name);
        }
    }
}

