/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ibm.icu.text.MessageFormat;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TooltipAnimation;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.theme.ThemeHelper;
import snownee.jade.key_extension.KeyExManager;
import snownee.jade.key_extension.KeyMappingEx;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.WailaExceptionHandler;

public final class JadeClient {
    public static final SystemToast.SystemToastId JADE_PLEASE_WAIT = new SystemToast.SystemToastId(2000L);
    public static final KeyMapping[] profiles = new KeyMapping[4];
    private static final WailaTickHandler tickHandler = new WailaTickHandler();
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showDetails;
    public static KeyMapping narrate;
    public static KeyMapping showRecipes;
    public static KeyMapping showUses;
    private static final Cache<Item.TooltipContext, Item.TooltipContext> hideModName;
    public static float renderDistanceStart;
    public static float renderDistanceEnd;
    private static boolean translationChecked;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void init() {
        openConfig = ClientProxy.registerKeyBinding("config", 320);
        showOverlay = ClientProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientProxy.registerKeyBinding("show_details", 340);
        for (int i = 0; i < 4; ++i) {
            JadeClient.profiles[i] = ClientProxy.registerKeyBinding("profile." + i, InputConstants.UNKNOWN.getValue());
        }
        ClientProxy.registerReloadListener(ModIdentification.INSTANCE);
        ClientProxy.registerReloadListener(HarvestToolProvider.INSTANCE);
        ClientProxy.registerReloadListener(ThemeHelper.INSTANCE);
    }

    public static WailaTickHandler tickHandler() {
        return tickHandler;
    }

    public static void onKeyPressed(int action) {
        IWailaConfig.General general;
        Minecraft mc = Minecraft.getInstance();
        while (openConfig.consumeClick()) {
            Jade.invalidateConfig();
            ItemStorageProvider.targetCache.invalidateAll();
            ItemStorageProvider.containerCache.invalidateAll();
            mc.setScreen((Screen)new HomeConfigScreen(null));
        }
        while (showOverlay.consumeClick()) {
            general = IWailaConfig.get().general();
            IWailaConfig.DisplayMode mode = general.getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && Jade.history().hintOverlayToggle) {
                mc.getChatListener().handleSystemMessage((Component)Component.translatable((String)"toast.jade.toggle_hint.1"), false);
                mc.getChatListener().handleSystemMessage((Component)Component.translatable((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.getTranslatedKeyMessage()}), false);
                Jade.history().hintOverlayToggle = false;
            }
            JadeClient.narrateKey("show_overlay", general.shouldDisplayTooltip());
            IWailaConfig.get().save();
        }
        while (toggleLiquid.consumeClick()) {
            general.setDisplayFluids(!(general = IWailaConfig.get().general()).shouldDisplayFluids());
            JadeClient.narrateKey("toggle_liquid", general.shouldDisplayFluids());
            IWailaConfig.get().save();
        }
        while (narrate.consumeClick()) {
            IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
            if (accessibility.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                accessibility.toggleTTS();
                if (accessibility.shouldEnableTextToSpeech() && Jade.history().hintNarratorToggle) {
                    mc.getChatListener().handleSystemMessage((Component)Component.translatable((String)"toast.jade.tts_hint.1"), false);
                    mc.getChatListener().handleSystemMessage((Component)Component.translatable((String)"toast.jade.tts_hint.2", (Object[])new Object[]{narrate.getTranslatedKeyMessage()}), false);
                    Jade.history().hintNarratorToggle = false;
                }
                IWailaConfig.get().save();
                continue;
            }
            if (JadeClient.tickHandler.rootElement == null) continue;
            tickHandler.narrate(JadeClient.tickHandler.rootElement, false);
        }
        if (Jade.rootConfig().isEnableProfiles()) {
            for (int i = 0; i < 4; ++i) {
                while (profiles[i].consumeClick()) {
                    Jade.useProfile(i);
                    if (!IWailaConfig.get().accessibility().getNarrateKeys()) continue;
                    tickHandler.narrate(I18n.get((String)"narration.jade.key.profile", (Object[])new Object[]{profiles[i].getName()}), false);
                }
            }
        }
    }

    public static void narrateKey(String key, boolean bl) {
        if (IWailaConfig.get().accessibility().getNarrateKeys()) {
            key = "narration.jade.key.%s.%s".formatted(key, bl ? "on" : "off");
            tickHandler.narrate(I18n.get((String)key, (Object[])new Object[0]), false);
        }
    }

    public static void onGui(Screen screen) {
        if (!translationChecked && screen instanceof TitleScreen && CommonProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (ResourceLocation id : WailaClientRegistration.instance().getConfigKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.getNamespace(), id.getPath());
                if (I18n.exists((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(String.join((CharSequence)",", keys)));
            }
        }
    }

    public static void hideModNameIn(Item.TooltipContext context) {
        hideModName.put((Object)context, (Object)context);
    }

    public static void appendModName(List<Component> tooltip, ItemStack stack, Item.TooltipContext tooltipContext, TooltipFlag flag) {
        String name;
        if (!IWailaConfig.get().general().showItemModNameTooltip() || hideModName.getIfPresent((Object)tooltipContext) != null) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            if (!(screen2.hoveredSlot == null || screen2.hoveredSlot.getItem() != stack || CreativeModeInventoryScreen.selectedTab.getType() == CreativeModeTab.Type.CATEGORY && flag.isCreative())) {
                return;
            }
        }
        try {
            name = ModIdentification.getModName(stack);
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(TraceableException.create(e, BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace()), null, tooltip::add);
            return;
        }
        tooltip.add((Component)Component.literal((String)name).withStyle(IWailaConfig.get().formatting().getItemModNameStyle()));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (WailaClientRegistration.instance().maybeLowVisionUser() || !IWailaConfig.get().general().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockState state;
            BlockAccessor target = (BlockAccessor)accessor;
            Player player = accessor.getPlayer();
            if (player.isCreative() || player.isSpectator()) {
                return accessor;
            }
            WailaClientRegistration client = WailaClientRegistration.instance();
            if (target.getBlock() instanceof ChestBlock && (state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState())) != target.getBlockState()) {
                return client.blockAccessor().from(target).blockState(state).build();
            }
            BlockAccessor.Builder builder = client.blockAccessor().from(target).blockEntity(() -> null);
            if (target.getBlock() instanceof InfestedBlock) {
                Block block = ((InfestedBlock)target.getBlock()).getHostBlock();
                return builder.blockState(block.defaultBlockState()).build();
            }
            if (target.getBlock() == Blocks.POWDER_SNOW) {
                Block block = Blocks.SNOW_BLOCK;
                return builder.blockState(block.defaultBlockState()).build();
            }
            Block block = target.getBlock();
            if (block instanceof BrushableBlock) {
                BrushableBlock brushable = (BrushableBlock)block;
                block = brushable.getTurnsInto();
                return builder.blockState(block.defaultBlockState()).build();
            }
        }
        return accessor;
    }

    @Nullable
    public static Accessor<?> limitMobEffectFog(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor == null) {
            return null;
        }
        if (WailaClientRegistration.instance().maybeLowVisionUser()) {
            return accessor;
        }
        Player player = accessor.getPlayer();
        Minecraft mc = Minecraft.getInstance();
        LightTexture lightTexture = mc.gameRenderer.lightTexture();
        float darknessEffectScale = ((Double)mc.options.darknessEffectScale().get()).floatValue();
        float gamma = player.getEffectBlendFactor(MobEffects.DARKNESS, 1.0f) * darknessEffectScale;
        if ((gamma = lightTexture.calculateDarknessScale((LivingEntity)player, gamma, 1.0f)) > 0.15f && accessor.getLevel().getMaxLocalRawBrightness(BlockPos.containing((Position)accessor.getHitResult().getLocation())) < 7) {
            return null;
        }
        if (renderDistanceStart == 0.0f && renderDistanceEnd == 0.0f) {
            return accessor;
        }
        float dist = (renderDistanceStart + renderDistanceEnd) * 0.5f;
        if (accessor.getHitResult().distanceTo((Entity)player) > (double)(dist * dist)) {
            return null;
        }
        return accessor;
    }

    public static void drawBreakingProgress(BoxElement root, TooltipAnimation animation, GuiGraphics graphics, Accessor<?> accessor) {
        if (!IWailaConfig.get().plugin().get(JadeIds.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        if (!Float.isNaN(root.getBoxProgress())) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        MultiPlayerGameMode playerController = mc.gameMode;
        if (playerController == null || mc.level == null || mc.player == null) {
            return;
        }
        BlockPos pos = playerController.destroyBlockPos;
        BlockState state = mc.level.getBlockState(pos);
        if (playerController.isDestroying()) {
            canHarvest = CommonProxy.isCorrectToolForDrops(state, (Player)mc.player, (Level)mc.level, pos);
        } else if (progressAlpha == 0.0f) {
            return;
        }
        Theme theme = IThemeHelper.get().theme();
        ColorPalette colors = theme.tooltipStyle.boxProgressColors;
        int color = canHarvest ? colors.title() : colors.failure();
        float top = root.getY() + root.getHeight();
        float width = root.getWidth();
        progressAlpha += mc.getDeltaTracker().getGameTimeDeltaTicks() * (playerController.isDestroying() ? 0.1f : -0.1f);
        if (playerController.isDestroying()) {
            progressAlpha = Math.min(progressAlpha, 0.6f);
            float progress = state.getDestroyProgress((Player)mc.player, (BlockGetter)mc.player.level(), pos);
            if (playerController.destroyProgress + progress >= 1.0f) {
                savedProgress = 1.0f;
                progressAlpha = 1.0f;
            } else {
                progress = playerController.destroyProgress + mc.getDeltaTracker().getGameTimeDeltaPartialTick(false) * progress;
                savedProgress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
            }
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        if (progressAlpha == 0.0f) {
            return;
        }
        color = IWailaConfig.Overlay.applyAlpha(color, progressAlpha);
        float offset0 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.UP);
        float offset1 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.RIGHT);
        float offset2 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.DOWN);
        float offset3 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.LEFT);
        DisplayHelper.fill(graphics, offset3, top - 1.0f + offset0, offset3 + (width += offset1 - offset3) * savedProgress, top + offset2, color);
    }

    public static MutableComponent format(String s, Object ... objects) {
        return Component.literal((String)JadeClient.formatString(s, objects));
    }

    public static String formatString(String s, Object ... objects) {
        try {
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (!(object instanceof Component)) continue;
                Component component = (Component)object;
                objects[i] = component.getString();
            }
            return MessageFormat.format((String)I18n.get((String)s, (Object[])new Object[0]), (Object[])objects);
        }
        catch (Exception e) {
            return I18n.get((String)s, (Object[])objects);
        }
    }

    public static void pleaseWait() {
        SystemToast.add((ToastManager)Minecraft.getInstance().getToastManager(), (SystemToast.SystemToastId)JADE_PLEASE_WAIT, (Component)Component.translatable((String)"toast.jade.please_wait.1"), (Component)Component.translatable((String)"toast.jade.please_wait.2"));
    }

    public static Runnable recoverKeysAction(Predicate<KeyMapping> predicate) {
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!predicate.test(keyMapping)) continue;
            keyMapBuilder.put((Object)keyMapping, (Object)((KeyMappingEx)keyMapping).keyEx$key());
        }
        ImmutableMap keyMap = keyMapBuilder.build();
        return () -> keyMap.forEach(KeyMapping::setKey);
    }

    public static void refreshKeyState() {
        boolean active = Jade.rootConfig().isEnableProfiles();
        for (KeyMapping keyMapping : profiles) {
            KeyMappingEx.setActive(keyMapping, active);
        }
        KeyExManager.setGlobalNoConflict(Jade.config().accessibility().getNoKeyConflict());
    }

    static {
        hideModName = CacheBuilder.newBuilder().weakKeys().weakValues().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    }
}

