/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import fuzs.stoneworks.world.block.variant.BlockVariant;
import java.util.Locale;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public enum StoneType {
    STONE(Blocks.STONE),
    ANDESITE(Blocks.ANDESITE),
    GRANITE(Blocks.GRANITE),
    DIORITE(Blocks.DIORITE),
    DEEPSLATE(Blocks.DEEPSLATE),
    CALCITE(Blocks.CALCITE),
    TUFF(Blocks.TUFF),
    BASALT(Blocks.BASALT),
    BLACKSTONE(Blocks.BLACKSTONE),
    NETHERRACK(Blocks.NETHERRACK, false){

        @Override
        public Block getBaseBlock(BlockVariant blockVariant) {
            if (blockVariant.usesNetherbricksMaterial()) {
                return Blocks.NETHER_BRICKS;
            }
            return super.getBaseBlock(blockVariant);
        }

        @Override
        public String getName(BlockVariant blockVariant) {
            if (blockVariant.usesNetherbricksMaterial()) {
                return "nether_brick";
            }
            return super.getName(blockVariant);
        }
    }
    ,
    END_STONE(Blocks.END_STONE, false),
    PURPUR(Blocks.PURPUR_BLOCK, false),
    PRISMARINE(Blocks.PRISMARINE, false),
    DARK_PRISMARINE(Blocks.DARK_PRISMARINE, false),
    SANDSTONE(Blocks.SANDSTONE, false),
    RED_SANDSTONE(Blocks.RED_SANDSTONE, false),
    QUARTZ(Blocks.QUARTZ_BLOCK, false);

    private final Block baseBlock;
    private final boolean isCobbleHardened;

    private StoneType(Block baseBlock) {
        this(baseBlock, true);
    }

    private StoneType(Block baseBlock, boolean isCobbleHardened) {
        this.baseBlock = baseBlock;
        this.isCobbleHardened = isCobbleHardened;
    }

    public Block getBaseBlock(BlockVariant blockVariant) {
        return this.baseBlock;
    }

    public BlockState getDefaultBlockState(BlockVariant blockVariant) {
        return this.getBaseBlock(blockVariant).defaultBlockState();
    }

    protected BlockBehaviour.Properties getBlockProperties(BlockVariant blockVariant) {
        Block baseBlock = this.getBaseBlock(blockVariant);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock);
        if (this.isCobbleHardened && blockVariant != BlockVariant.REGULAR) {
            properties.strength(baseBlock.defaultDestroyTime() + 0.5f, baseBlock.getExplosionResistance());
        }
        return properties;
    }

    public String getName(BlockVariant blockVariant) {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean hasChiseledMotif() {
        return this == DIORITE || this == DEEPSLATE || this == CALCITE || this == TUFF || this == BLACKSTONE || this == NETHERRACK || this == PRISMARINE || this == DARK_PRISMARINE || this == SANDSTONE || this == RED_SANDSTONE;
    }
}

