/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.data.client;

import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneVariantsProvider;
import java.util.Objects;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public void addBlockModels(BlockModelGenerators blockModelGenerators) {
        for (StoneBlockVariant variant : StoneVariantsProvider.getStoneBlockVariants().toList()) {
            TextureMapping textureMapping;
            ModelTemplate modelTemplate;
            if (variant.blockVariant() == BlockVariant.PILLAR) {
                blockModelGenerators.createRotatedPillarWithHorizontalVariant(variant.block(), TexturedModel.COLUMN, TexturedModel.COLUMN_HORIZONTAL);
                continue;
            }
            if (variant.blockVariant() == BlockVariant.CHISELED && variant.stoneType().hasChiseledMotif()) {
                StoneBlockVariant polishedVariant = StoneVariantsProvider.getStoneVariant(variant.stoneType(), BlockVariant.POLISHED);
                modelTemplate = ModelTemplates.CUBE_COLUMN;
                textureMapping = TextureMapping.column((ResourceLocation)ModelLocationHelper.getBlockTexture((Block)variant.block()), (ResourceLocation)ModelLocationHelper.getBlockTexture((Block)polishedVariant.block()));
            } else {
                modelTemplate = ModelTemplates.CUBE_ALL;
                textureMapping = TextureMapping.cube((Block)variant.block());
            }
            BlockModelGenerators blockModelGenerators2 = blockModelGenerators;
            Objects.requireNonNull(blockModelGenerators2);
            BlockModelGenerators.BlockFamilyProvider blockFamilyProvider = new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators2, textureMapping).fullBlock(variant.block(), modelTemplate);
            if (!variant.blockVariant().supportsAdditionalBlocks()) continue;
            blockFamilyProvider.stairs(variant.stairs()).slab(variant.slab()).wall(variant.wall());
        }
    }

    public void addItemModels(ItemModelGenerators itemModelGenerators) {
        super.addItemModels(itemModelGenerators);
    }
}

