/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventConditionRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;

public record DigSpotRecipe(EventCondition eventCondition, ResourceKey<LootTable> lootTable, int weight) implements Recipe<RecipeInput>
{
    public RecipeType<DigSpotRecipe> getType() {
        return ModRecipeTypes.digSpotRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.digSpotRecipeBookCategory;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<DigSpotRecipe> getSerializer() {
        return ModRecipeTypes.digSpotRecipeSerializer;
    }

    public static class Serializer
    implements RecipeSerializer<DigSpotRecipe> {
        private static final MapCodec<DigSpotRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventConditionRegistry.CODEC.fieldOf("eventCondition").forGetter(DigSpotRecipe::eventCondition), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(DigSpotRecipe::lootTable), (App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(DigSpotRecipe::weight)).apply((Applicative)instance, DigSpotRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, DigSpotRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static DigSpotRecipe fromNetwork(FriendlyByteBuf buf) {
            EventCondition eventCondition = EventConditionRegistry.conditionFromNetwork(buf);
            ResourceKey lootTable = buf.readResourceKey(Registries.LOOT_TABLE);
            int weight = buf.readInt();
            return new DigSpotRecipe(eventCondition, (ResourceKey<LootTable>)lootTable, weight);
        }

        private static void toNetwork(FriendlyByteBuf buf, DigSpotRecipe recipe) {
            EventConditionRegistry.conditionToNetwork(buf, recipe.eventCondition);
            buf.writeResourceKey(recipe.lootTable);
            buf.writeInt(recipe.weight);
        }

        public MapCodec<DigSpotRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DigSpotRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

