/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.loot;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.loot.BalmLootModifier;
import net.blay09.mods.littlejoys.block.entity.FishingSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.FishingSpotHandler;
import net.blay09.mods.littlejoys.handler.FishingSpotHolder;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class FishingSpotLootModifier
implements BalmLootModifier {
    private static final Set<LootContext> activeContexts = new HashSet<LootContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(LootContext context, List<ItemStack> list) {
        BlockEntity blockEntity;
        FishingSpotHolder fishingSpotHolder;
        Player player;
        Set<LootContext> set = activeContexts;
        synchronized (set) {
            if (activeContexts.contains(context)) {
                return;
            }
        }
        ServerLevel level = context.getLevel();
        Vec3 origin = (Vec3)context.getOptionalParameter(LootContextParams.ORIGIN);
        Entity entity = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (origin == null || !(entity instanceof FishingSpotHolder) || !((player = (fishingSpotHolder = (FishingSpotHolder)entity).littlejoys$getPlayerOwner()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Optional<BlockPos> fishingSpotPos = fishingSpotHolder.getFishingSpot();
        if (fishingSpotPos.isPresent() && (blockEntity = level.getBlockEntity(fishingSpotPos.get())) instanceof FishingSpotBlockEntity) {
            FishingSpotBlockEntity fishingSpot = (FishingSpotBlockEntity)blockEntity;
            FishingSpotHandler.resolveRecipe(level, fishingSpotPos.get(), fishingSpot.getRecipeId(), player2).ifPresent(recipeHolder -> {
                ResourceKey<LootTable> lootTableId = ((FishingSpotRecipe)recipeHolder.value()).lootTable();
                LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
                Set<LootContext> set = activeContexts;
                synchronized (set) {
                    activeContexts.add(context);
                }
                lootTable.getRandomItems(context, list::add);
                set = activeContexts;
                synchronized (set) {
                    activeContexts.remove(context);
                }
            });
        }
    }
}

