/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.loot;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.loot.BalmLootModifier;
import net.blay09.mods.littlejoys.block.entity.DigSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.DigSpotHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DigSpotLootModifier
implements BalmLootModifier {
    private static final Set<LootContext> activeContexts = new HashSet<LootContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(LootContext context, List<ItemStack> list) {
        Set<LootContext> set = activeContexts;
        synchronized (set) {
            if (activeContexts.contains(context)) {
                return;
            }
        }
        ServerLevel level = context.getLevel();
        Vec3 vec = (Vec3)context.getOptionalParameter(LootContextParams.ORIGIN);
        BlockState state = (BlockState)context.getOptionalParameter(LootContextParams.BLOCK_STATE);
        BlockEntity blockEntity = (BlockEntity)context.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (state == null || vec == null || !(blockEntity instanceof DigSpotBlockEntity)) {
            return;
        }
        DigSpotBlockEntity digSpot = (DigSpotBlockEntity)blockEntity;
        DigSpotHandler.recipeById(level, digSpot.getRecipeId()).ifPresent(recipe -> {
            ResourceKey<LootTable> lootTableId = recipe.lootTable();
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
            Set<LootContext> set = activeContexts;
            synchronized (set) {
                activeContexts.add(context);
            }
            lootTable.getRandomItems(context, list::add);
            set = activeContexts;
            synchronized (set) {
                activeContexts.remove(context);
            }
        });
    }
}

