/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.entity;

import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.littlejoys.entity.ModEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DropRushItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<CompoundTag> DATA_TARGET = SynchedEntityData.defineId(DropRushItemEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private int ticksPassed;
    private int actualLifetime = 6000;
    private boolean pickedUp;

    public DropRushItemEntity(EntityType<? extends ItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DropRushItemEntity(Level level, double posX, double posY, double posZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityType<? extends ItemEntity>)((EntityType)ModEntities.dropRushItem.get()), level);
        this.setPos(posX, posY, posZ);
        this.setDeltaMovement(deltaX, deltaY, deltaZ);
        this.setItem(itemStack);
    }

    public DropRushItemEntity(DropRushItemEntity other) {
        super(other.getType(), other.level());
        this.setItem(other.getItem().copy());
        this.copyPosition((Entity)other);
        this.ticksPassed = other.ticksPassed;
        this.actualLifetime = other.actualLifetime;
        this.pickedUp = other.pickedUp;
    }

    public void tick() {
        super.tick();
        ++this.ticksPassed;
        if (this.ticksPassed >= this.actualLifetime) {
            this.discard();
        }
        if (this.level().isClientSide && !this.onGround()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        if (this.pickedUp) {
            this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY() + 0.25, this.getZ(), 0.0, 0.0, 0.0);
        } else {
            this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 0.25, this.getZ(), 0.0, 0.0, 0.0);
            this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.25, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void setActualLifetime(int actualLifetime) {
        this.actualLifetime = actualLifetime;
    }

    public boolean isPickedUp() {
        return this.pickedUp;
    }

    public void setPickedUp(boolean pickedUp) {
        this.pickedUp = pickedUp;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_TARGET) {
            ((CompoundTag)this.getEntityData().get(DATA_TARGET)).read("Target", UUIDUtil.CODEC).ifPresent(this::setTarget);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TARGET, (Object)new CompoundTag());
    }

    public boolean isCurrentlyGlowing() {
        Player player = Balm.getProxy().getClientPlayer();
        return player != null && Objects.equals(this.getTarget(), player.getUUID());
    }

    public int getTeamColor() {
        return ChatFormatting.RED.getColor();
    }

    @Nullable
    public UUID getTarget() {
        return ((CompoundTag)this.getEntityData().get(DATA_TARGET)).read("Target", UUIDUtil.CODEC).orElse(null);
    }

    public void setTarget(@Nullable UUID target) {
        super.setTarget(target);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.storeNullable("Target", UUIDUtil.CODEC, (Object)target);
        this.getEntityData().set(DATA_TARGET, (Object)compoundTag);
    }

    public ItemEntity copy() {
        return new DropRushItemEntity(this);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (reason == Entity.RemovalReason.DISCARDED && this.getItem().isEmpty()) {
            this.setPickedUp(true);
        }
    }
}

