/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.littlejoys.entity.DropRushItemEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.world.entity.item.ItemEntity;

public class DropRushItemRenderer
extends ItemEntityRenderer {
    public DropRushItemRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ItemEntityRenderState renderState, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean mine;
        UUID uUID;
        LocalPlayer player = Minecraft.getInstance().player;
        if (renderState instanceof DropRushItemEntityRenderState) {
            DropRushItemEntityRenderState state = (DropRushItemEntityRenderState)renderState;
            uUID = state.getTarget();
        } else {
            uUID = null;
        }
        UUID target = uUID;
        boolean bl = mine = player != null && Objects.equals(target, player.getUUID());
        if (mine) {
            super.render(renderState, poseStack, buffer, packedLight);
        } else {
            super.render(renderState, poseStack, buffer, packedLight);
        }
    }

    public ItemEntityRenderState createRenderState() {
        return new DropRushItemEntityRenderState();
    }

    public void extractRenderState(ItemEntity itemEntity, ItemEntityRenderState renderState, float partialTicks) {
        super.extractRenderState(itemEntity, renderState, partialTicks);
        if (itemEntity instanceof DropRushItemEntity) {
            DropRushItemEntity dropRushItemEntity = (DropRushItemEntity)itemEntity;
            if (renderState instanceof DropRushItemEntityRenderState) {
                DropRushItemEntityRenderState dropRushItemEntityRenderState = (DropRushItemEntityRenderState)renderState;
                dropRushItemEntityRenderState.setTarget(dropRushItemEntity.getTarget());
            }
        }
    }

    private static class DropRushItemEntityRenderState
    extends ItemEntityRenderState {
        private UUID target;

        private DropRushItemEntityRenderState() {
        }

        public UUID getTarget() {
            return this.target;
        }

        public void setTarget(UUID target) {
            this.target = target;
        }
    }
}

