/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.block;

import com.mojang.serialization.MapCodec;
import net.blay09.mods.littlejoys.block.entity.FishingSpotBlockEntity;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FishingSpotBlock
extends BaseEntityBlock {
    public static final MapCodec<FishingSpotBlock> CODEC = FishingSpotBlock.simpleCodec(FishingSpotBlock::new);
    private static final VoxelShape SHAPE = Shapes.empty();

    public FishingSpotBlock(BlockBehaviour.Properties properties) {
        super(properties.replaceable());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posBelow = pos.below();
        return this.mayPlaceOn(level.getBlockState(posBelow), (BlockGetter)level, posBelow);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        return !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, randomSource);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        return fluidState.is(FluidTags.WATER) && fluidState.isSource();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float x = (float)pos.getX() + 0.5f;
        float y = (float)pos.getY() - 0.1f;
        float z = (float)pos.getZ() + 0.5f;
        float offsetX = 0.2f - random.nextFloat() * 0.4f;
        float offsetZ = 0.2f - random.nextFloat() * 0.4f;
        level.addAlwaysVisibleParticle((ParticleOptions)ModParticles.fishingSpot, (double)(x + offsetX), (double)y, (double)(z + offsetZ), 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FishingSpotBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }
}

