/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.util.block_tracking;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Objects;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.block.TrackedBlockStatePredicate;
import net.caffeinemc.mods.lithium.common.tracking.block.ChunkSectionChangeCallback;
import net.caffeinemc.mods.lithium.common.tracking.block.SectionedBlockChangeTracker;
import net.caffeinemc.mods.lithium.common.world.section.LithiumSectionData;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkSection.class})
public abstract class LevelChunkSectionMixin
implements BlockCountingSection,
BlockListeningSection,
LithiumSectionData {
    @Shadow
    @Final
    private PalettedContainer<BlockState> states;

    @Inject(method={"<init>(Lnet/minecraft/core/Registry;)V"}, at={@At(value="RETURN")})
    private void initAirSection(Registry<?> registry, CallbackInfo ci) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getCountsByFlag() != null) {
            throw new IllegalStateException("CountsByFlag already initialized!");
        }
        sectionData.setCountsByFlag(new short[BlockStateFlags.NUM_TRACKED_FLAGS]);
        for (TrackedBlockStatePredicate trackedBlockStatePredicate : BlockStateFlags.TRACKED_FLAGS) {
            if (!this.states.maybeHas((Predicate)trackedBlockStatePredicate)) continue;
            sectionData.getCountsByFlag()[trackedBlockStatePredicate.getIndex()] = 4096;
        }
    }

    @ModifyArg(method={"recalcBlockCounts()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V"))
    private PalettedContainer.CountConsumer<BlockState> initFlagCounters(PalettedContainer.CountConsumer<BlockState> countConsumer) {
        short[] countsByFlag = Objects.requireNonNull(this.lithium$getSectionData().getCountsByFlag());
        return (state, count) -> {
            countConsumer.accept(state, count);
            LevelChunkSectionMixin.addToFlagCount(countsByFlag, state, (short)count);
        };
    }

    @Inject(method={"recalcBlockCounts()V"}, at={@At(value="HEAD")})
    private void createFlagCounters(CallbackInfo ci) {
        this.lithium$getSectionData().setCountsByFlag(new short[BlockStateFlags.NUM_TRACKED_FLAGS]);
    }

    @Inject(method={"read(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="HEAD")})
    private void resetData(FriendlyByteBuf buf, CallbackInfo ci) {
        this.lithium$getSectionData().setCountsByFlag(null);
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)})
    private void updateFlagCounters(int x, int y, int z, BlockState newState, boolean lock, CallbackInfoReturnable<BlockState> cir, @Local(ordinal=1) BlockState oldState) {
        this.lithium$trackBlockStateChange(newState, oldState);
        ChunkSectionChangeCallback changeListener = this.lithium$getSectionData().getChangeListener();
        if (changeListener != null) {
            changeListener.onBlockChange(this);
        }
    }

    @Unique
    private static void addToFlagCount(short[] countsByFlag, BlockState state, short change) {
        int i;
        int flags = ((BlockStateFlagHolder)state).lithium$getAllFlags();
        while ((i = Integer.numberOfTrailingZeros(flags)) < 32 && i < countsByFlag.length) {
            int n = i;
            countsByFlag[n] = (short)(countsByFlag[n] + change);
            flags &= ~(1 << i);
        }
    }

    @Override
    public short lithium$getCount(int predicateIndex) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getCountsByFlag() == null) {
            this.fastInitClientCounts();
        }
        return sectionData.getCountsByFlag()[predicateIndex];
    }

    @Override
    public boolean lithium$mayContainAny(TrackedBlockStatePredicate trackedBlockStatePredicate) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getCountsByFlag() == null) {
            this.fastInitClientCounts();
        }
        return sectionData.getCountsByFlag()[trackedBlockStatePredicate.getIndex()] != 0;
    }

    @Unique
    private void fastInitClientCounts() {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        sectionData.setCountsByFlag(new short[BlockStateFlags.NUM_TRACKED_FLAGS]);
        for (TrackedBlockStatePredicate trackedBlockStatePredicate : BlockStateFlags.TRACKED_FLAGS) {
            if (!this.states.maybeHas((Predicate)trackedBlockStatePredicate)) continue;
            sectionData.getCountsByFlag()[trackedBlockStatePredicate.getIndex()] = 4096;
        }
    }

    @Override
    public void lithium$trackBlockStateChange(BlockState newState, BlockState oldState) {
        int flagIndex;
        short[] countsByFlag = this.lithium$getSectionData().getCountsByFlag();
        if (countsByFlag == null) {
            return;
        }
        int prevFlags = ((BlockStateFlagHolder)oldState).lithium$getAllFlags();
        int flags = ((BlockStateFlagHolder)newState).lithium$getAllFlags();
        int flagsXOR = prevFlags ^ flags;
        while ((flagIndex = Integer.numberOfTrailingZeros(flagsXOR)) < 32 && flagIndex < countsByFlag.length) {
            int flagBit = 1 << flagIndex;
            if ((flagsXOR & flagBit) != 0) {
                int n = flagIndex;
                countsByFlag[n] = (short)(countsByFlag[n] + (short)(1 - ((prevFlags >>> flagIndex & 1) << 1)));
            }
            flagsXOR &= ~flagBit;
        }
    }

    @Override
    public void lithium$addToCallback(SectionedBlockChangeTracker tracker, long sectionPos, Level world) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getChangeListener() == null) {
            if (sectionPos == Long.MIN_VALUE || world == null) {
                throw new IllegalArgumentException("Expected world and section pos during intialization!");
            }
            sectionData.setChangeListener(ChunkSectionChangeCallback.create(sectionPos, world));
        }
        sectionData.getChangeListener().addTracker(tracker);
    }

    @Override
    public void lithium$removeFromCallback(SectionedBlockChangeTracker tracker) {
        ChunkSectionChangeCallback changeListener = this.lithium$getSectionData().getChangeListener();
        if (changeListener != null) {
            changeListener.removeTracker(tracker);
        }
    }
}

