/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.experimental.entity.block_caching.suffocation;

import net.caffeinemc.mods.lithium.common.tracking.VicinityCache;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCacheProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements VicinityCacheProvider {
    @Shadow
    public Level level;
    @Shadow
    private EntityDimensions dimensions;

    protected EntityMixin(EntityDimensions dimensions) {
        this.dimensions = dimensions;
    }

    @Inject(method={"isInWall"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;betweenClosedStream(Lnet/minecraft/world/phys/AABB;)Ljava/util/stream/Stream;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void isInsideWall(CallbackInfoReturnable<Boolean> cir, float f, AABB box) {
        int minX = Mth.floor((double)box.minX);
        int minY = Mth.floor((double)box.minY);
        int minZ = Mth.floor((double)box.minZ);
        int maxX = Mth.floor((double)box.maxX);
        int maxY = Mth.floor((double)box.maxY);
        int maxZ = Mth.floor((double)box.maxZ);
        VicinityCache bc = this.getUpdatedVicinityCache((Entity)this);
        byte cachedSuffocation = bc.getIsSuffocating();
        if (cachedSuffocation == 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (cachedSuffocation == 1) {
            cir.setReturnValue((Object)true);
            return;
        }
        Level world = this.level;
        if (world.getMinY() > maxY || world.getMaxY() < minY) {
            bc.setCachedIsSuffocating(false);
            cir.setReturnValue((Object)false);
            return;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        VoxelShape suffocationShape = null;
        boolean shouldCache = true;
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    blockPos.set(x, y, z);
                    BlockState blockState = world.getBlockState((BlockPos)blockPos);
                    if (blockState.isAir() || !blockState.isSuffocating((BlockGetter)this.level, (BlockPos)blockPos)) continue;
                    if (shouldCache && blockState.is(BlockTags.SHULKER_BOXES)) {
                        shouldCache = false;
                    }
                    if (suffocationShape == null) {
                        suffocationShape = Shapes.create((AABB)new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ));
                    }
                    if (!Shapes.joinIsNotEmpty((VoxelShape)blockState.getCollisionShape((BlockGetter)this.level, (BlockPos)blockPos).move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (VoxelShape)suffocationShape, (BooleanOp)BooleanOp.AND)) continue;
                    if (shouldCache) {
                        bc.setCachedIsSuffocating(true);
                    }
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
        if (shouldCache) {
            bc.setCachedIsSuffocating(false);
        }
        cir.setReturnValue((Object)false);
    }
}

