/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.neoforge;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.CommonServer;
import nx.pingwheel.common.command.ServerCommandBuilder;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.neoforge.NeoClient;
import nx.pingwheel.neoforge.platform.PlatformContextServiceImpl;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="pingwheel")
public class NeoMain {
    public static final String NEOFORGE_ID = "pingwheel";
    private static final StreamCodec<FriendlyByteBuf, PingLocationS2CPacket> PING_LOCATION_S2C_CODEC = StreamCodec.ofMember(PingLocationS2CPacket::write, PingLocationS2CPacket::readSafe);
    private static final StreamCodec<FriendlyByteBuf, PingLocationC2SPacket> PING_LOCATION_C2S_CODEC = StreamCodec.ofMember(PingLocationC2SPacket::write, PingLocationC2SPacket::readSafe);
    private static final StreamCodec<FriendlyByteBuf, UpdateChannelC2SPacket> UPDATE_CHANNEL_C2S_CODEC = StreamCodec.ofMember(UpdateChannelC2SPacket::write, UpdateChannelC2SPacket::readSafe);

    public NeoMain(IEventBus modBus) {
        CommonServer.INSTANCE.onInit();
        PlatformContextServiceImpl.modBus = modBus;
        modBus.addListener(this::onRegisterPackets);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        if (FMLEnvironment.dist.isClient()) {
            new NeoClient(modBus);
        }
    }

    public void onRegisterPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("ping-wheel").optional();
        registrar.playToClient(PingLocationS2CPacket.PACKET_TYPE, PING_LOCATION_S2C_CODEC, (payload, context) -> context.enqueueWork(() -> CommonClient.INSTANCE.onPingLocationPacket((PingLocationS2CPacket)payload)));
        registrar.playToServer(PingLocationC2SPacket.PACKET_TYPE, PING_LOCATION_C2S_CODEC, (payload, context) -> context.enqueueWork(() -> CommonServer.INSTANCE.onPingLocationPacket(context.player().getServer(), (ServerPlayer)context.player(), (PingLocationC2SPacket)payload)));
        registrar.playToServer(UpdateChannelC2SPacket.PACKET_TYPE, UPDATE_CHANNEL_C2S_CODEC, (payload, context) -> context.enqueueWork(() -> CommonServer.INSTANCE.onChannelUpdatePacket(context.player().getServer(), (ServerPlayer)context.player(), (UpdateChannelC2SPacket)payload)));
    }

    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(ServerCommandBuilder.build((TriConsumer<CommandContext<CommandSourceStack>, Boolean, MutableComponent>)((TriConsumer)(context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LanguageUtils.withModPrefix(response));
            }
        })));
    }
}

