/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class DirectionIndicatorRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static Vec2 screenSize;
    private static Vec2 safeZoneTopLeft;
    private static Vec2 safeZoneBottomRight;
    private static Vec2 safeScreenCenter;

    private DirectionIndicatorRenderer() {
    }

    public static void prepareSafeZone() {
        Window wnd = CommonClient.Game.getWindow();
        screenSize = new Vec2((float)wnd.getGuiScaledWidth(), (float)wnd.getGuiScaledHeight());
        safeZoneTopLeft = new Vec2((float)CLIENT_CONFIG.getSafeZoneLeft(), (float)CLIENT_CONFIG.getSafeZoneTop());
        safeZoneBottomRight = new Vec2(DirectionIndicatorRenderer.screenSize.x - (float)CLIENT_CONFIG.getSafeZoneRight(), DirectionIndicatorRenderer.screenSize.y - (float)CLIENT_CONFIG.getSafeZoneBottom());
        safeScreenCenter = new Vec2((DirectionIndicatorRenderer.safeZoneBottomRight.x - DirectionIndicatorRenderer.safeZoneTopLeft.x) * 0.5f, (DirectionIndicatorRenderer.safeZoneBottomRight.y - DirectionIndicatorRenderer.safeZoneTopLeft.y) * 0.5f);
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean isOffScreen;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        boolean behindCamera = screenPos.isBehindCamera();
        boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(Vec2.ZERO, screenSize);
        if (!isOffScreen) {
            return;
        }
        Vec2 pingDirectionVec = new Vec2(screenPos.x - DirectionIndicatorRenderer.safeZoneTopLeft.x - DirectionIndicatorRenderer.safeScreenCenter.x, screenPos.y - DirectionIndicatorRenderer.safeZoneTopLeft.y - DirectionIndicatorRenderer.safeScreenCenter.y);
        if (behindCamera) {
            pingDirectionVec = pingDirectionVec.scale(-1.0f);
        }
        Matrix3x2fStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        float pingAngle = (float)Math.atan2(pingDirectionVec.y, pingDirectionVec.x);
        Vec2 edgePosition = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
        float indicatorOffsetX = (float)Math.cos((double)pingAngle + Math.PI) * 12.0f;
        float indicatorOffsetY = (float)Math.sin((double)pingAngle + Math.PI) * 12.0f;
        m.pushMatrix();
        m.translate(edgePosition.x, edgePosition.y);
        m.pushMatrix();
        m.scale(pingScale, pingScale);
        m.translate(indicatorOffsetX, indicatorOffsetY);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible());
        m.popMatrix();
        m.pushMatrix();
        MathUtils.rotateZ((Matrix3x2f)m, pingAngle);
        m.scale(pingSize, pingSize);
        m.scale(0.25f, 0.25f);
        m.translate(-5.0f, 0.0f);
        ctx.renderArrowIcon();
        m.popMatrix();
        m.popMatrix();
    }
}

