/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.biome.Biome;

public class BiomeInfoScreen
extends Screen {
    private NaturesCompassScreen parentScreen;
    private Biome biome;
    private Button searchButton;
    private Button backButton;
    private String source;
    private String tags;
    private String temperature;
    private String rainfall;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, Biome biome) {
        super((Component)Component.translatable((String)BiomeUtils.getBiomeNameForDisplay(parentScreen.level, biome)));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.source = BiomeUtils.getBiomeSource(parentScreen.level, biome);
        this.tags = BiomeUtils.getBiomeTags(parentScreen.level, biome);
        this.temperature = (double)biome.getBaseTemperature() <= 0.5 ? I18n.get((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.getBaseTemperature() <= 1.5 ? I18n.get((String)"string.naturescompass.medium", (Object[])new Object[0]) : I18n.get((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.getModifiedClimateSettings().downfall() <= 0.0f ? I18n.get((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().downfall() < 0.2 ? I18n.get((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().downfall() < 0.3 ? I18n.get((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().downfall() < 0.5 ? I18n.get((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().downfall() < 0.85 ? I18n.get((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.get((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
    }

    public void init() {
        this.setupWidgets();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), this.width / 2 - this.font.width(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)) / 2, 20, -1);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"string.naturescompass.source"), this.width / 2 - 100, 40, -1);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)this.source), this.width / 2 - 100, 50, -8355712);
        int tagsMaxWidth = this.width / 2 - 50;
        Object tagsLine = this.tags;
        if (this.font.width((String)tagsLine) > tagsMaxWidth) {
            tagsLine = this.font.plainSubstrByWidth((String)tagsLine + "...", tagsMaxWidth) + "...";
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"string.naturescompass.tags"), this.width / 2 + 40, 40, -1);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)tagsLine), this.width / 2 + 40, 50, -8355712);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"string.naturescompass.rainfall"), this.width / 2 + 40, 70, -1);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)this.rainfall), this.width / 2 + 40, 80, -8355712);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"string.naturescompass.temperature"), this.width / 2 - 100, 100, -1);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)this.temperature), this.width / 2 - 100, 110, -8355712);
    }

    private void setupWidgets() {
        this.clearWidgets();
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"string.naturescompass.back"), onPress -> this.minecraft.setScreen((Screen)this.parentScreen)));
        this.searchButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(this.width - 120, this.height - 30, 110, 20, (Component)Component.translatable((String)"string.naturescompass.search"), onPress -> this.parentScreen.searchForBiome(this.biome)));
    }
}

