/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.collections;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class FilteredList<T>
extends ObjectArrayList<T> {
    private final Predicate<T> filter;

    public FilteredList(int capacity, Predicate<T> filter) {
        super(capacity);
        this.filter = filter;
    }

    @NotNull
    public ObjectListIterator<T> listIterator(int index) {
        ObjectListIterator iterator = super.listIterator(index);
        return new FilteringIterator(iterator);
    }

    private class FilteringIterator
    implements ObjectListIterator<T> {
        private final Iterator<T> iterator;
        private T next;

        private FilteringIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.calculateNext();
        }

        public T next() {
            if (this.calculateNext()) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            throw new NoSuchElementException();
        }

        private boolean calculateNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                Object object = this.iterator.next();
                if (!FilteredList.this.filter.test(object)) continue;
                this.next = object;
                return true;
            }
            return false;
        }

        public T previous() {
            throw new UnsupportedOperationException();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }
    }
}

