/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Steep
extends RoofBlock {
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)15.99, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)15.99, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)15.99, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)15.99, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)8.0), Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)15.99, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)8.0), Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)15.99, (double)16.0)};
    protected static final VoxelShape[] TOP_SHAPES = Steep.createStairShapes(SHAPES[0], SHAPES[2], SHAPES[6], SHAPES[3], SHAPES[7]);
    protected static final VoxelShape[] BOTTOM_SHAPES = Steep.createStairShapes(SHAPES[1], SHAPES[4], SHAPES[8], SHAPES[5], SHAPES[9]);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] createStairShapes(VoxelShape baseShape, VoxelShape ... shapes) {
        VoxelShape[] stairShapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            stairShapes[i] = baseShape;
            for (int j = 0; j < shapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stairShapes[i] = Shapes.or((VoxelShape)stairShapes[i], (VoxelShape)shapes[j]);
            }
        }
        return stairShapes;
    }

    public Steep(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext collision) {
        VoxelShape[] shapes = state.getValue((Property)HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES;
        int shapeIndex = this.getShapeIndex(state);
        return shapes[SHAPE_BY_STATE[shapeIndex]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue((Property)SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    @Override
    protected BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue((Property)SHAPE, (Comparable)Steep.getStairsShape((BlockGetter)worldIn, currentPos, (Direction)stateIn.getValue((Property)FACING), (Half)stateIn.getValue((Property)HALF))) : super.updateShape(stateIn, worldIn, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.getBlockState(pos.relative(direction));
        if (Steep.isSteep(blockstate) && half == blockstate.getValue((Property)HALF) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != facing.getAxis() && Steep.canTakeShape(direction1.getOpposite(), blockstate, reader, pos)) {
            return direction1 == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.getBlockState(pos.relative(direction.getOpposite()));
        if (Steep.isSteep(blockstate1) && half == blockstate1.getValue((Property)HALF) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != facing.getAxis() && Steep.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.getBlockState(pos.relative(dir));
        return !Steep.isSteep(blockstate) || blockstate.getValue((Property)FACING) != state.getValue((Property)FACING) || blockstate.getValue((Property)HALF) != state.getValue((Property)HALF);
    }

    public static boolean isSteep(BlockState state) {
        return state.getBlock() instanceof Steep;
    }
}

