/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib;

import com.google.common.collect.ImmutableMap;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.builtinpacks.BuiltInPackConfig;
import de.cristelknight.cristellib.builtinpacks.RuntimePack;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CristelLib {
    public static final String MOD_ID = "cristellib";
    public static final Logger LOGGER = LogManager.getLogger((String)"Cristel Lib");
    public static final ResourceLocation CRISTEL_LIB_PACK_RL = ResourceLocation.fromNamespaceAndPath((String)"cristellib", (String)"runtime_pack");
    public static final RuntimePack DATA_PACK = new RuntimePack(CRISTEL_LIB_PACK_RL, SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA), "Runtime Pack for built-in features", CristelLibExpectPlatform.getResourceDirectory("cristellib", "pack.png"));
    private static final CristelLibRegistry REGISTRY = new CristelLibRegistry();

    public static String getWithPrefix(String message) {
        return String.format("[%s] %s", MOD_ID, message);
    }

    public static void init() {
    }

    public static void preInit() {
        BuiltInDataPackLoader.registerPack(DATA_PACK, (Component)Component.literal((String)"Cristel Lib Config Pack"), () -> true);
        CristelLibRegistry.configs = ImmutableMap.copyOf(CristelLibExpectPlatform.getConfigs(REGISTRY));
        BuiltInDataPackLoader.freeze();
        BuiltInPackConfig.updateConfig();
        for (Set pack : CristelLibRegistry.getConfigs().values()) {
            for (StructureConfig structureConfig : pack) {
                structureConfig.writeConfig();
                structureConfig.addSetsToRuntimePack();
            }
        }
    }
}

