/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import java.util.Vector;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.helpers.ColorHelper;
import squeek.appleskin.helpers.ConsumableFood;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.helpers.TextureHelper;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    protected static int foodIconsOffset;
    protected static int healthIconsOffset;
    private static final OffsetsCache barOffsets;
    private static final HeldFoodCache heldFood;
    private static final RandomSource random;

    public static void register(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.PLAYER_HEALTH, ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"health_offset"), (guiGraphics, deltaTracker) -> {
            healthIconsOffset = Minecraft.getInstance().gui.leftHeight;
        });
        event.registerBelow(VanillaGuiLayers.FOOD_LEVEL, ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"food_offset"), (guiGraphics, deltaTracker) -> {
            foodIconsOffset = Minecraft.getInstance().gui.rightHeight;
        });
        event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, HealthOverlay.ID, (GuiLayer)new HealthOverlay());
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, HungerOverlay.ID, (GuiLayer)new HungerOverlay());
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, SaturationOverlay.ID, (GuiLayer)new SaturationOverlay());
        event.registerBelow(VanillaGuiLayers.FOOD_LEVEL, ExhaustionOverlay.ID, (GuiLayer)new ExhaustionOverlay());
        NeoForge.EVENT_BUS.addListener(HUDOverlayHandler::onClientTick);
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Player player, GuiGraphics guiGraphics, int right, int top, float alpha, int guiTicks) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        int alphaColor = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, alpha);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        Vector<IntPoint> offsets = barOffsets.foodBarOffsets(guiTicks, player);
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset;
            IntPoint intPoint = offset = i < offsets.size() ? offsets.get(i) : new IntPoint();
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            boolean v = false;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TextureHelper.MOD_ICONS, x, y, (float)u, (float)v, iconSize, iconSize, 256, 256, alphaColor);
        }
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Player player, GuiGraphics guiGraphics, int right, int top, float alpha, boolean useRottenTextures, int guiTicks) {
        if (hungerRestored <= 0) {
            return;
        }
        int alphaColor = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, alpha);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        Vector<IntPoint> offsets = barOffsets.foodBarOffsets(guiTicks, player);
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset;
            IntPoint intPoint = offset = i < offsets.size() ? offsets.get(i) : new IntPoint();
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            ResourceLocation backgroundSprite = TextureHelper.getFoodTexture(useRottenTextures, TextureHelper.FoodType.EMPTY);
            int bgColor = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, alpha * 0.25f);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, backgroundSprite, x, y, iconSize, iconSize, bgColor);
            boolean isHalf = i * 2 + 1 == modifiedFood;
            ResourceLocation iconSprite = TextureHelper.getFoodTexture(useRottenTextures, isHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, iconSprite, x, y, iconSize, iconSize, alphaColor);
        }
    }

    public static void drawHealthOverlay(float health, float modifiedHealth, Player player, GuiGraphics guiGraphics, int right, int top, float alpha, int guiTicks) {
        if (modifiedHealth <= health) {
            return;
        }
        int alphaColor = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, alpha);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = player.level().getLevelData().isHardcore();
        int startHealthBars = (int)Math.max(0.0, Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.max(0.0, Math.ceil(modifiedHealth / 2.0f));
        int iconSize = 9;
        Vector<IntPoint> offsets = barOffsets.healthBarOffsets(guiTicks, player);
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset;
            IntPoint intPoint = offset = i < offsets.size() ? offsets.get(i) : new IntPoint();
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            ResourceLocation backgroundSprite = TextureHelper.getHeartTexture(isHardcore, TextureHelper.HeartType.CONTAINER);
            int bgColor = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, alpha * 0.25f);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, backgroundSprite, x, y, iconSize, iconSize, bgColor);
            boolean isHalf = i * 2 + 1 == fixedModifiedHealth;
            ResourceLocation iconSprite = TextureHelper.getHeartTexture(isHardcore, isHalf ? TextureHelper.HeartType.HALF : TextureHelper.HeartType.FULL);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, iconSprite, x, y, iconSize, iconSize, alphaColor);
        }
    }

    public static void drawExhaustionOverlay(float exhaustion, Player player, GuiGraphics guiGraphics, int right, int top, float alpha) {
        float maxExhaustion = HungerHelper.getMaxExhaustion(player);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        int color = ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 0.75f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TextureHelper.MOD_ICONS, right - width, top, (float)(81 - width), 18.0f, width, height, 256, 256, color);
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ((Double)ModConfig.MAX_HUD_OVERLAY_FLASH_ALPHA.get()).floatValue()));
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static void drawSaturationOverlay(HUDOverlayEvent.Saturation event, Player player, float saturationGained, float alpha, int guiTicks) {
        HUDOverlayHandler.drawSaturationOverlay(saturationGained, event.saturationLevel, player, event.guiGraphics, event.x, event.y, alpha, guiTicks);
    }

    private static void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, Player player, int hunger, float alpha, boolean useRottenTextures, int guiTicks) {
        HUDOverlayHandler.drawHungerOverlay(hunger, event.currentFoodLevel, player, event.guiGraphics, event.x, event.y, alpha, useRottenTextures, guiTicks);
    }

    private static void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, Player player, float alpha, int guiTicks) {
        HUDOverlayHandler.drawHealthOverlay(player.getHealth(), event.modifiedHealth, player, event.guiGraphics, event.x, event.y, alpha, guiTicks);
    }

    private static void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, Player player, float alpha) {
        HUDOverlayHandler.drawExhaustionOverlay(event.exhaustion, player, event.guiGraphics, event.x, event.y, alpha);
    }

    private static boolean shouldShowEstimatedHealth(Player player) {
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        FoodData stats = player.getFoodData();
        if (player.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (stats.getFoodLevel() >= 18) {
            return false;
        }
        if (player.hasEffect(MobEffects.POISON)) {
            return false;
        }
        if (player.hasEffect(MobEffects.WITHER)) {
            return false;
        }
        return !player.hasEffect(MobEffects.REGENERATION);
    }

    static {
        barOffsets = new OffsetsCache();
        heldFood = new HeldFoodCache();
        random = RandomSource.create();
    }

    public static class HealthOverlay
    extends Overlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"health_restored");

        @Override
        public void render(Minecraft mc, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            FoodHelper.QueriedFoodResult result = heldFood.result(guiTicks, player);
            if (result == null) {
                HUDOverlayHandler.resetFlash();
                return;
            }
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(player, new ConsumableFood(result.modifiedFoodProperties, result.consumable));
            float currentHealth = player.getHealth();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.getMaxHealth());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, result.itemStack, result.modifiedFoodProperties, left, top - healthIconsOffset, guiGraphics);
            }
            if (healthRenderEvent != null) {
                NeoForge.EVENT_BUS.post(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled()) {
                HUDOverlayHandler.drawHealthOverlay(healthRenderEvent, player, flashAlpha, guiTicks);
            }
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            if (player.getVehicle() instanceof LivingEntity) {
                return false;
            }
            if (barOffsets.healthBarOffsets(guiTicks, player).isEmpty()) {
                return false;
            }
            return HUDOverlayHandler.shouldShowEstimatedHealth(player);
        }
    }

    public static class HungerOverlay
    extends Overlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"hunger_restored");

        @Override
        public void render(Minecraft mc, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            FoodData stats = player.getFoodData();
            FoodHelper.QueriedFoodResult result = heldFood.result(guiTicks, player);
            if (result == null) {
                HUDOverlayHandler.resetFlash();
                return;
            }
            ItemStack heldItem = result.itemStack;
            FoodProperties modifiedFoodProperties = result.modifiedFoodProperties;
            HUDOverlayEvent.HungerRestored renderRenderEvent = new HUDOverlayEvent.HungerRestored(stats.getFoodLevel(), heldItem, modifiedFoodProperties, right, top - foodIconsOffset, guiGraphics);
            NeoForge.EVENT_BUS.post((Event)renderRenderEvent);
            if (renderRenderEvent.isCanceled()) {
                return;
            }
            int foodHunger = modifiedFoodProperties.nutrition();
            float foodSaturationIncrement = modifiedFoodProperties.saturation();
            HUDOverlayHandler.drawHungerOverlay(renderRenderEvent, player, foodHunger, flashAlpha, FoodHelper.isRotten(result.consumable), guiTicks);
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            return (Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get();
        }
    }

    public static class SaturationOverlay
    extends Overlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"saturation_level");

        @Override
        public void render(Minecraft mc, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            FoodData stats = player.getFoodData();
            HUDOverlayEvent.Saturation saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.getSaturationLevel(), right, top - foodIconsOffset, guiGraphics);
            if (!saturationRenderEvent.isCanceled()) {
                NeoForge.EVENT_BUS.post((Event)saturationRenderEvent);
            }
            if (saturationRenderEvent.isCanceled()) {
                return;
            }
            HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, player, 0.0f, 1.0f, guiTicks);
            FoodHelper.QueriedFoodResult result = heldFood.result(guiTicks, player);
            if (result == null) {
                return;
            }
            FoodProperties modifiedFoodProperties = result.modifiedFoodProperties;
            int foodHunger = modifiedFoodProperties.nutrition();
            float foodSaturationIncrement = modifiedFoodProperties.saturation();
            int newFoodValue = stats.getFoodLevel() + foodHunger;
            float newSaturationValue = stats.getSaturationLevel() + foodSaturationIncrement;
            float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.getSaturationLevel() : foodSaturationIncrement;
            HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, player, saturationGained, flashAlpha, guiTicks);
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            return (Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get();
        }
    }

    public static class ExhaustionOverlay
    extends Overlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"exhaustion_level");

        @Override
        public void render(Minecraft mc, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            float exhaustion = player.getFoodData().exhaustionLevel;
            HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top - foodIconsOffset, guiGraphics);
            NeoForge.EVENT_BUS.post((Event)renderEvent);
            if (!renderEvent.isCanceled()) {
                HUDOverlayHandler.drawExhaustionOverlay(renderEvent, player, 1.0f);
            }
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            if (!super.shouldRenderOverlay(mc, player, guiGraphics, guiTicks)) {
                return false;
            }
            if (player.getVehicle() instanceof LivingEntity) {
                return false;
            }
            return (Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get();
        }
    }

    private static class OffsetsCache {
        protected final Vector<IntPoint> foodBarOffsets = new Vector();
        protected final Vector<IntPoint> healthBarOffsets = new Vector();
        public int lastGuiTick = 0;

        private OffsetsCache() {
        }

        protected void generate(int guiTicks, Player player) {
            int i;
            float absorptionHealth;
            int preferHealthBars = 10;
            int preferFoodBars = 10;
            float maxHealth = player.getMaxHealth();
            int healthBars = (int)Math.ceil((maxHealth + (absorptionHealth = (float)Math.ceil(player.getAbsorptionAmount()))) / 2.0f);
            if (healthBars < 0 || healthBars > 1000) {
                healthBars = 0;
            }
            int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
            int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
            boolean shouldAnimatedFood = false;
            boolean shouldAnimatedHealth = false;
            if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
                FoodData stats = player.getFoodData();
                float saturationLevel = stats.getSaturationLevel();
                int foodLevel = stats.getFoodLevel();
                shouldAnimatedFood = saturationLevel <= 0.0f && guiTicks % (foodLevel * 3 + 1) == 0;
                shouldAnimatedHealth = Math.ceil(player.getHealth()) <= 4.0;
            }
            random.setSeed((long)guiTicks * 312871L);
            if (this.foodBarOffsets.size() != 10) {
                this.foodBarOffsets.setSize(10);
            }
            if (this.healthBarOffsets.size() != healthBars) {
                this.healthBarOffsets.setSize(healthBars);
            }
            for (i = healthBars - 1; i >= 0; --i) {
                IntPoint point;
                int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
                int x = i % 10 * 8;
                int y = -(row * healthRowHeight);
                if (shouldAnimatedHealth) {
                    y += random.nextInt(2);
                }
                if ((point = this.healthBarOffsets.get(i)) == null) {
                    point = new IntPoint();
                    this.healthBarOffsets.set(i, point);
                }
                point.x = x;
                point.y = y;
            }
            for (i = 0; i < 10; ++i) {
                IntPoint point;
                int x = -(i * 8) - 9;
                int y = 0;
                if (shouldAnimatedFood) {
                    y += random.nextInt(3) - 1;
                }
                if ((point = this.foodBarOffsets.get(i)) == null) {
                    point = new IntPoint();
                    this.foodBarOffsets.set(i, point);
                }
                point.x = x;
                point.y = y;
            }
        }

        public Vector<IntPoint> healthBarOffsets(int guiTick, Player player) {
            if (guiTick != this.lastGuiTick) {
                this.generate(guiTick, player);
                this.lastGuiTick = guiTick;
            }
            return this.healthBarOffsets;
        }

        public Vector<IntPoint> foodBarOffsets(int guiTicks, Player player) {
            if (guiTicks != this.lastGuiTick) {
                this.generate(guiTicks, player);
                this.lastGuiTick = guiTicks;
            }
            return this.foodBarOffsets;
        }
    }

    public static class HeldFoodCache {
        @Nullable
        protected FoodHelper.QueriedFoodResult result;
        public int lastGuiTick = 0;

        protected void query(Player player) {
            boolean shouldRenderHeldItemValues;
            boolean canConsume;
            ItemStack heldItem = player.getMainHandItem();
            FoodHelper.QueriedFoodResult heldFood = FoodHelper.query(heldItem, player);
            boolean bl = canConsume = heldFood != null && FoodHelper.canConsume(player, heldFood.modifiedFoodProperties);
            if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !canConsume) {
                heldItem = player.getOffhandItem();
                heldFood = FoodHelper.query(heldItem, player);
                canConsume = heldFood != null && FoodHelper.canConsume(player, heldFood.modifiedFoodProperties);
            }
            boolean bl2 = shouldRenderHeldItemValues = !heldItem.isEmpty() && canConsume;
            if (!shouldRenderHeldItemValues) {
                this.result = null;
                return;
            }
            this.result = heldFood;
        }

        public FoodHelper.QueriedFoodResult result(int guiTick, Player player) {
            if (guiTick != this.lastGuiTick) {
                this.query(player);
                this.lastGuiTick = guiTick;
            }
            return this.result;
        }
    }

    public static abstract class Overlay
    implements GuiLayer {
        public abstract void render(Minecraft var1, Player var2, GuiGraphics var3, int var4, int var5, int var6, int var7);

        public final void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || !this.shouldRenderOverlay(mc, (Player)mc.player, guiGraphics, mc.gui.getGuiTicks())) {
                return;
            }
            int top = guiGraphics.guiHeight();
            int left = guiGraphics.guiWidth() / 2 - 91;
            int right = guiGraphics.guiWidth() / 2 + 91;
            this.render(mc, (Player)mc.player, guiGraphics, left, right, top, mc.gui.getGuiTicks());
        }

        public boolean shouldRenderOverlay(Minecraft mc, Player player, GuiGraphics guiGraphics, int guiTicks) {
            return !mc.options.hideGui && mc.gameMode != null && mc.gameMode.canHurtPlayer();
        }
    }
}

