/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.neoforge.tile;

import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.level.ElevatorContainer;
import com.vsngarcia.neoforge.client.render.ElevatorBakedModel;
import com.vsngarcia.neoforge.init.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.model.data.ModelData;

public class ElevatorBlockEntity
extends ElevatorBlockEntityBase {
    public ElevatorBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.ELEVATOR_TILE_ENTITY.get(), pos, state);
    }

    @Override
    protected SoundEvent camouflageSound() {
        return Registry.CAMOUFLAGE_SOUND.get();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new ElevatorContainer(Registry.ELEVATOR_CONTAINER.get(), id, this.worldPosition, player);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ElevatorBakedModel.HELD_STATE, (Object)this.heldState).build();
    }

    @Override
    public void setChanged() {
        AuxiliaryLightManager auxLightManager;
        super.setChanged();
        this.requestModelDataUpdate();
        AuxiliaryLightManager auxiliaryLightManager = auxLightManager = this.level != null ? this.level.getAuxLightManager(this.worldPosition) : null;
        if (auxLightManager == null) {
            return;
        }
        auxLightManager.setLightAt(this.worldPosition, this.heldState != null ? this.heldState.getLightEmission((BlockGetter)this.level, this.worldPosition) : 0);
    }

    public void handleUpdateTag(ValueInput in) {
        super.handleUpdateTag(in);
        this.setChanged();
    }

    public void onDataPacket(Connection net, ValueInput in) {
        this.handleUpdateTag(in);
    }
}

