/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.neoforge.init;

import com.vsngarcia.level.ElevatorContainer;
import com.vsngarcia.neoforge.ElevatorBlock;
import com.vsngarcia.neoforge.tile.ElevatorBlockEntity;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registry {
    public static final EnumMap<DyeColor, DeferredBlock<ElevatorBlock>> ELEVATOR_BLOCKS = new EnumMap(DyeColor.class);
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"elevatorid");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final Supplier<BlockEntityType<ElevatorBlockEntity>> ELEVATOR_TILE_ENTITY;
    public static final EnumMap<DyeColor, DeferredItem<BlockItem>> ELEVATOR_ITEMS;
    private static final DeferredRegister.Items ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    public static Supplier<MenuType<ElevatorContainer>> ELEVATOR_CONTAINER;
    private static final DeferredRegister<SoundEvent> SOUNDS;
    public static final Supplier<SoundEvent> TELEPORT_SOUND;
    public static final Supplier<SoundEvent> CAMOUFLAGE_SOUND;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS;
    private static final Supplier<CreativeModeTab> ELEVATORS_TAB;

    public static void init(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        SOUNDS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
    }

    static {
        Arrays.stream(DyeColor.values()).forEach(color -> ELEVATOR_BLOCKS.put((DyeColor)color, (DeferredBlock<ElevatorBlock>)BLOCKS.register("elevator_" + color.getName(), () -> new ElevatorBlock((DyeColor)color))));
        BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"elevatorid");
        ELEVATOR_TILE_ENTITY = BLOCK_ENTITIES.register("elevator_tile", () -> new BlockEntityType(ElevatorBlockEntity::new, (Block[])ELEVATOR_BLOCKS.values().stream().map(DeferredHolder::get).toArray(Block[]::new)));
        ELEVATOR_ITEMS = new EnumMap(DyeColor.class);
        ITEMS = DeferredRegister.createItems((String)"elevatorid");
        ELEVATOR_BLOCKS.forEach((color, o) -> ELEVATOR_ITEMS.put((DyeColor)color, (DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem((Holder)o)));
        CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"elevatorid");
        ELEVATOR_CONTAINER = null;
        ELEVATOR_CONTAINER = CONTAINERS.register("elevator_container", () -> IMenuTypeExtension.create((windowId, inv, data) -> new ElevatorContainer(ELEVATOR_CONTAINER.get(), windowId, data.readBlockPos(), inv.player)));
        SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"elevatorid");
        TELEPORT_SOUND = SOUNDS.register("teleport", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"teleport")));
        CAMOUFLAGE_SOUND = SOUNDS.register("camouflage", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"camouflage")));
        CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"elevatorid");
        ELEVATORS_TAB = CREATIVE_TABS.register("elevators_tab", () -> CreativeModeTab.builder().icon(() -> ((BlockItem)ELEVATOR_ITEMS.get(DyeColor.WHITE).get()).getDefaultInstance()).displayItems((params, output) -> ELEVATOR_ITEMS.values().forEach(item -> output.accept((ItemLike)item.get()))).title((Component)Component.translatable((String)"itemGroup.elevators_tab")).build());
    }
}

