/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public enum Priority implements StringRepresentable
{
    LOWEST,
    LOW,
    NORMAL,
    HIGH,
    HIGHEST;

    public static final Priority[] VALUES;
    private final String name = this.name().toLowerCase(Locale.ROOT);
    public static final Codec<Priority> CODEC;

    public Priority add(Priority other) {
        if (this == NORMAL) {
            return other;
        }
        if (other == NORMAL) {
            return this;
        }
        return Priority.fromSorting(this.getSorting() + other.getSorting());
    }

    public int getSorting() {
        return this.ordinal() - 2;
    }

    public static Priority fromSorting(int sorting) {
        return Priority.values()[Mth.clamp((int)(sorting + 2), (int)0, (int)(Priority.values().length - 1))];
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        VALUES = Priority.values();
        CODEC = StringRepresentable.fromEnum(Priority::values);
    }

    public static interface IPriority {
        public static final Function<Object, Priority> GETTER = IPriority::get;

        public Priority getPriority();

        public static <T> Comparator<T> compare() {
            return Comparator.comparing(GETTER);
        }

        public static Priority get(Object o) {
            if (o instanceof IPriority) {
                IPriority p = (IPriority)o;
                return p.getPriority();
            }
            return NORMAL;
        }
    }
}

