/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;

public class CraftingMatrix
implements CraftingContainer {
    private final NonNullList<ItemStack> items;
    private final int width;
    private final int height;
    private final Runnable onChanged;

    public CraftingMatrix(int i, int j, Runnable onChanged) {
        this(i, j, onChanged, (NonNullList<ItemStack>)NonNullList.withSize((int)(i * j), (Object)ItemStack.EMPTY));
    }

    public CraftingMatrix(int i, int j, Runnable onChanged, NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
        this.width = i;
        this.height = j;
        this.onChanged = onChanged;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        ItemStack itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).isEmpty());
        return false;
    }

    public ItemStack getItem(int i) {
        return i >= this.getContainerSize() ? ItemStack.EMPTY : (ItemStack)this.items.get(i);
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.items, (int)i);
    }

    public ItemStack removeItem(int i, int j) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)i, (int)j);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public void setItem(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        this.setChanged();
    }

    public void setChanged() {
        this.onChanged.run();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public List<ItemStack> getItems() {
        return List.copyOf(this.items);
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemStack : this.items) {
            stackedItemContents.accountSimpleStack(itemStack);
        }
    }
}

