/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.lwjgl.glfw.GLFW;

public abstract class ListWidget<T>
extends AbstractWidget {
    protected static final WidgetSprites LIST_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button_disabled"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button_hovered"));
    protected static final WidgetSprites LIST_BUTTON_SPRITES_S = new WidgetSprites(ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button_selected"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button_disabled"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_button_selected_hovered"));
    protected static final WidgetSprites SCROLL_SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_scroll"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_scroll_disabled"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/small_scroll_hovered"));
    private final int elemH;
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;
    protected Supplier<List<T>> list;
    protected T selected;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();

    public ListWidget(int x, int y, int w, int h, int elemH, Component narrator) {
        super(x, y, w, h, narrator);
        this.elemH = elemH;
        for (int i = 0; i < this.getLines(); ++i) {
            this.listEntries.add(new ListEntry(x, y + i * elemH, i));
        }
    }

    public void preRender(int mouseX, int mouseY) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0) != 0;
        int k = this.getX() + 56;
        int l = this.getY() - 1;
        int i1 = k + 14;
        int j1 = l + 58;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 4.5f) / ((float)(j1 - l) - 9.0f);
            this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderWidget(GuiGraphics st, int mouseX, int mouseY, float p_268085_) {
        int x = this.getX() + this.getWidth() - 6;
        int y = this.getY() - 1 + (int)((float)(this.getHeight() - 9) * this.currentScroll);
        boolean isHovered = mouseX >= x && mouseY >= y && mouseX < x + 5 && mouseY < y + 9;
        st.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLL_SPRITES.get(this.needsScrollBars(), isHovered), x, y, 5, 9);
    }

    public void tooltip(GuiGraphics matrixStack, int mouseX, int mouseY) {
        this.listEntries.stream().filter(s -> s.isHovered()).findFirst().ifPresent(le -> {
            Object id = le.getId();
            if (id != null) {
                this.renderTooltip(matrixStack, id, mouseX, mouseY);
            }
        });
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public boolean mouseScrolled(double p_94734_, double p_94735_, double p_94736_, double dir) {
        return this.scroll(dir);
    }

    private boolean scroll(double dir) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = this.list.get().size() - this.getLines();
        this.currentScroll = (float)((double)this.currentScroll - dir / (double)i);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    public boolean needsScrollBars() {
        return this.list.get().size() > this.getLines();
    }

    public int getLines() {
        return this.height / this.elemH;
    }

    public void setList(Supplier<List<T>> list) {
        this.list = list;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getSelected() {
        return this.selected;
    }

    public void setCurrentScroll(float currentScroll) {
        this.currentScroll = currentScroll;
    }

    protected abstract Font getFont();

    protected abstract void addButton(AbstractWidget var1);

    protected abstract Component toComponent(T var1);

    protected abstract void renderTooltip(GuiGraphics var1, T var2, int var3, int var4);

    protected void selectionChanged(T to) {
    }

    protected void renderEntry(GuiGraphics st, int x2, int y2, int width, int height, T id, int mouseX, int mouseY, float pt) {
    }

    public class ListEntry
    extends Button {
        private int id;

        public ListEntry(int x, int y, int id) {
            super(x, y, ListWidget.this.width - 8, ListWidget.this.elemH, (Component)Component.empty(), null, DEFAULT_NARRATION);
            this.id = id;
            ListWidget.this.addButton((AbstractWidget)this);
        }

        public void renderWidget(GuiGraphics st, int mouseX, int mouseY, float pt) {
            Object id;
            if (this.visible && (id = this.getId()) != null) {
                int x = this.getX();
                int y = this.getY();
                this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
                ResourceLocation spr = (id.equals(ListWidget.this.selected) ? LIST_BUTTON_SPRITES_S : LIST_BUTTON_SPRITES).get(this.active, this.isHoveredOrFocused());
                st.blitSprite(RenderPipelines.GUI_TEXTURED, spr, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                ListWidget.this.renderEntry(st, this.getX(), this.getY(), this.getWidth(), this.getHeight(), id, mouseX, mouseY, pt);
                int c = this.active ? 0xFFFFFF : 0xA0A0A0;
                int v = c | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
                int k = this.getX() + 2;
                int l = this.getX() + this.getWidth() - 2;
                AbstractWidget.renderScrollingString((GuiGraphics)st, (Font)ListWidget.this.getFont(), (Component)ListWidget.this.toComponent(id), (int)k, (int)this.getY(), (int)l, (int)(this.getY() + this.getHeight()), (int)v);
            }
        }

        public boolean mouseScrolled(double p_94734_, double p_94735_, double p_94736_, double dir) {
            return ListWidget.this.scroll(dir);
        }

        public void onPress() {
            Object id = this.getId();
            if (id != null) {
                ListWidget.this.selected = id;
                ListWidget.this.selectionChanged(id);
            }
        }

        private T getId() {
            List l = ListWidget.this.list.get();
            int i = l.size() - ListWidget.this.getLines();
            int j = (int)((double)(ListWidget.this.currentScroll * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < l.size()) {
                return l.get(this.id + j);
            }
            return null;
        }
    }
}

