/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.entity.InventoryConnectorBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.components.ConfiguratorComponent;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.item.ILeftClickListener;
import com.tom.storagemod.menu.InventoryConfiguratorMenu;
import com.tom.storagemod.platform.PlatformItem;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class InventoryConfiguratorItem
extends PlatformItem
implements ILeftClickListener {
    public InventoryConfiguratorItem(Item.Properties pr) {
        super(pr);
    }

    @Override
    public InteractionResult onRightClick(Player player, ItemStack stack, BlockPos pos, InteractionHand hand) {
        if (!player.level().isClientSide) {
            this.action(player.level(), player, stack, true, pos, hand);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        this.action(level, player, player.getItemInHand(hand), true, null, hand);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean onLeftClick(ItemStack itemstack, BlockPos pos, Player player) {
        if (!player.level().isClientSide) {
            this.action(player.level(), player, itemstack, false, pos, InteractionHand.MAIN_HAND);
        }
        return true;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        ConfiguratorComponent c;
        Player player;
        if (entity instanceof Player && stack != (player = (Player)entity).getItemInHand(InteractionHand.MAIN_HAND) && stack != player.getItemInHand(InteractionHand.OFF_HAND) && ((c = (ConfiguratorComponent)stack.get(Content.configuratorComponent.get())).showInvBox() || c.massSelect())) {
            stack.set(Content.configuratorComponent.get(), (Object)c.hiddenItem(level.getGameTime()));
        }
    }

    private void action(Level level, Player player, ItemStack stack, boolean rclk, BlockPos useOn, InteractionHand hand) {
        ConfiguratorComponent.Configurator c = new ConfiguratorComponent.Configurator(stack, level.getGameTime());
        if (c.debounce()) {
            return;
        }
        if (c.isBound()) {
            int x = c.bound().getX();
            int y = c.bound().getY();
            int z = c.bound().getZ();
            BlockPos pos2 = new BlockPos(x, y, z);
            if (player.distanceToSqr((double)x, (double)y, (double)z) < 256.0 && level.isLoaded(pos2)) {
                BlockFilter f = BlockFilter.getOrCreateFilterAt(level, pos2);
                if (f == null) {
                    stack.set(Content.configuratorComponent.get(), (Object)ConfiguratorComponent.empty());
                } else if (!(useOn == null || !c.selecting() || player.isSecondaryUseActive() && rclk)) {
                    if (rclk) {
                        if (!useOn.equals((Object)pos2)) {
                            if (!f.getConnectedBlocks().remove(useOn)) {
                                f.addConnected(level, useOn);
                            }
                            c.setSelection(f.getConnectedBlocks());
                            level.blockEntityChanged(pos2);
                            return;
                        }
                    } else {
                        if (!player.isSecondaryUseActive()) {
                            if (c.massSelect()) {
                                int sz;
                                int sy;
                                int sx = c.boxStart().getX();
                                AABB bb = new AABB((double)sx, (double)(sy = c.boxStart().getY()), (double)(sz = c.boxStart().getZ()), (double)useOn.getX(), (double)useOn.getY(), (double)useOn.getZ());
                                if (bb.getXsize() * bb.getYsize() * bb.getZsize() < 64.0) {
                                    BlockPos.betweenClosedStream((AABB)bb).forEach(p -> f.addConnected(level, (BlockPos)p));
                                    level.blockEntityChanged(pos2);
                                    c.massSelectEnd(f.getConnectedBlocks());
                                } else {
                                    player.displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.area_too_big"), true);
                                    c.massSelectEnd();
                                }
                            } else {
                                c.massSelectStart(useOn);
                            }
                            return;
                        }
                        c.massSelectEnd();
                        return;
                    }
                    c.clear();
                } else if (rclk) {
                    this.openMenu(level, player, pos2, f, hand);
                    c.clear();
                    return;
                }
            }
        }
        if (useOn != null && player.distanceToSqr((double)useOn.getX(), (double)useOn.getY(), (double)useOn.getZ()) < 256.0) {
            BlockEntity blockEntity;
            if (!rclk && (blockEntity = level.getBlockEntity(useOn)) instanceof InventoryConnectorBlockEntity) {
                InventoryConnectorBlockEntity ic = (InventoryConnectorBlockEntity)blockEntity;
                c.clear();
                c.showInvBox(ic.getConnectedBlocks());
                return;
            }
            BlockFilter f = BlockFilter.findBlockFilterAt(level, useOn);
            if (f == null) {
                return;
            }
            if (rclk) {
                this.openMenu(level, player, useOn, f, hand);
                f.getConnectedBlocks().forEach(pos -> {
                    if (!pos.equals((Object)f.getMainPos())) {
                        PlatformInventoryAccess.removeBlockFilterAt(level, pos);
                    }
                });
            }
            c.showInvBox(f.getConnectedBlocks());
        }
    }

    private void openMenu(Level level, Player player, final BlockPos pos, final BlockFilter f, final InteractionHand hand) {
        BlockEntity be = level.getBlockEntity(pos);
        Component blockName = null;
        if (be instanceof Nameable) {
            Nameable n = (Nameable)be;
            blockName = n.getDisplayName();
        }
        if (blockName == null) {
            blockName = level.getBlockState(pos).getBlock().getName();
        }
        final Component fbn = blockName;
        player.openMenu(new MenuProvider(){

            public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
                return new InventoryConfiguratorMenu(p_39954_, p_39955_, pos, f, hand);
            }

            public Component getDisplayName() {
                return Component.translatable((String)"menu.toms_storage.inventory_configurator", (Object[])new Object[]{fbn});
            }
        });
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay p_399753_, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("inventory_configurator", tooltip, new Object[0]);
    }
}

