/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.block.IConfiguratorHighlight;
import com.tom.storagemod.client.CustomRenderTypes;
import com.tom.storagemod.client.ViveCraftHelper;
import com.tom.storagemod.components.ConfiguratorComponent;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.ComponentJoiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientUtil {
    private static Component[] tooltipExt = new Component[0];

    public static void tooltip(String key, Consumer<Component> tooltip, Object ... args) {
        ClientUtil.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean addShift, Consumer<Component> tooltip, Object ... args) {
        if (Screen.hasShiftDown()) {
            String[] sp = I18n.get((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.accept((Component)Component.literal((String)sp[i]));
            }
        } else if (addShift) {
            tooltip.accept((Component)Component.translatable((String)"tooltip.toms_storage.hold_shift_for_info").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    public static void collectExtraTooltips(ItemStack stack, List<Component> toolip) {
        Collections.addAll(toolip, tooltipExt);
    }

    public static void drawTerminalOutline(PoseStack ps) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!WirelessTerminalItem.isPlayerHolding((Player)player)) {
            return;
        }
        BlockHitResult lookingAt = ClientUtil.rayTrace((Player)player, Config.get().wirelessRange, true);
        BlockState state = mc.level.getBlockState(lookingAt.getBlockPos());
        if (state.is(StorageTags.REMOTE_ACTIVATE)) {
            BlockPos pos = lookingAt.getBlockPos();
            Vec3 renderPos = mc.gameRenderer.getMainCamera().getPosition();
            VertexConsumer buf = mc.renderBuffers().bufferSource().getBuffer(RenderType.lines());
            ClientUtil.drawShape(ps, buf, state.getOcclusionShape(), (double)pos.getX() - renderPos.x, (double)pos.getY() - renderPos.y, (double)pos.getZ() - renderPos.z, 1.0f, 1.0f, 1.0f, 0.4f);
            mc.renderBuffers().bufferSource().endBatch(RenderType.lines());
        }
    }

    private static BlockHitResult rayTrace(Player player, double maxDist, boolean hitFluids) {
        HitResult vr;
        if (Platform.vivecraft && (vr = ViveCraftHelper.rayTraceVR(maxDist, hitFluids)) != null) {
            return (BlockHitResult)vr;
        }
        return (BlockHitResult)player.pick(maxDist, 0.0f, hitFluids);
    }

    public static void drawConfiguratorOutline(PoseStack ps) {
        HitResult x2;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack is = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!is.is((Item)Content.invConfig.get())) {
            is = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (!is.is((Item)Content.invConfig.get())) {
            return;
        }
        ConfiguratorComponent c = (ConfiguratorComponent)is.get(Content.configuratorComponent.get());
        if (!c.selecting() && !c.showInvBox()) {
            ClientUtil.drawPaintedHighlights(ps);
            return;
        }
        Vec3 renderPos = mc.gameRenderer.getMainCamera().getPosition();
        VertexConsumer buf = mc.renderBuffers().bufferSource().getBuffer(RenderType.lines());
        for (BlockPos pos : c.selection()) {
            double x2 = (double)pos.getX() - renderPos.x;
            double y = (double)pos.getY() - renderPos.y;
            double z = (double)pos.getZ() - renderPos.z;
            ClientUtil.renderLineBox(ps, buf, x2, y, z, x2 + 1.0, y + 1.0, z + 1.0, 1.0f, 1.0f, 1.0f, 0.4f);
        }
        VertexConsumer bufNd = mc.renderBuffers().bufferSource().getBuffer(CustomRenderTypes.linesNoDepth());
        if (c.massSelect() && (x2 = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult hr = (BlockHitResult)x2;
            int sx = c.boxStart().getX();
            int sy = c.boxStart().getY();
            int sz = c.boxStart().getZ();
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(sx, sy, sz), (BlockPos)hr.getBlockPos());
            bb = bb.move(-renderPos.x, -renderPos.y, -renderPos.z);
            ClientUtil.renderLineBox(ps, bufNd, bb, 1.0f, 1.0f, 0.0f, 0.4f);
        }
        if (c.isBound()) {
            double x3 = (double)c.bound().getX() - renderPos.x;
            double y = (double)c.bound().getY() - renderPos.y;
            double z = (double)c.bound().getZ() - renderPos.z;
            ClientUtil.renderLineBox(ps, bufNd, x3, y, z, x3 + 1.0, y + 1.0, z + 1.0, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        mc.renderBuffers().bufferSource().endBatch();
    }

    private static void drawPaintedHighlights(PoseStack ps) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        VertexConsumer buf = mc.renderBuffers().bufferSource().getBuffer(CustomRenderTypes.linesNoDepth());
        Vec3 renderPos = mc.gameRenderer.getMainCamera().getPosition();
        BlockPos.betweenClosedStream((AABB)new AABB(player.blockPosition()).inflate(7.0)).forEach(pos -> {
            double dist = renderPos.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (dist > 49.0) {
                return;
            }
            BlockState state = mc.level.getBlockState(pos);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof IConfiguratorHighlight) {
                IConfiguratorHighlight h = (IConfiguratorHighlight)patt0$temp;
                VoxelShape shape = h.getHighlightShape(state, (BlockGetter)mc.level, (BlockPos)pos);
                int color = h.getHighlightColor();
                float a = 1.0f;
                if (dist > 25.0) {
                    a = 1.0f - (float)((dist - 25.0) / 24.0);
                }
                ClientUtil.drawShape(ps, buf, shape, (double)pos.getX() - renderPos.x, (double)pos.getY() - renderPos.y, (double)pos.getZ() - renderPos.z, (float)ARGB.red((int)color) / 255.0f, (float)ARGB.green((int)color) / 255.0f, (float)ARGB.blue((int)color) / 255.0f, a);
            }
        });
    }

    private static void drawShape(PoseStack matrices, VertexConsumer vertexConsumer, VoxelShape voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        PoseStack.Pose entry = matrices.last();
        voxelShape.forAllEdges((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.sqrt((float)(q * q + r * r + s * s));
            vertexConsumer.addVertex(entry.pose(), (float)(k + d), (float)(l + e), (float)(m + f)).setColor(g, h, i, j).setNormal(entry, q /= t, r /= t, s /= t);
            vertexConsumer.addVertex(entry.pose(), (float)(n + d), (float)(o + e), (float)(p + f)).setColor(g, h, i, j).setNormal(entry, q, r, s);
        });
    }

    public static Component multilineTooltip(String text, Object ... objects) {
        return Arrays.stream(I18n.get((String)text, (Object[])objects).split("\\\\")).map(Component::literal).collect(ComponentJoiner.joining((Component)Component.empty(), (Component)Component.literal((String)"\n")));
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer vertexConsumer, AABB aABB, float f, float g, float h, float i) {
        ClientUtil.renderLineBox(poseStack, vertexConsumer, aABB.minX, aABB.minY, aABB.minZ, aABB.maxX, aABB.maxY, aABB.maxZ, f, g, h, i, f, g, h);
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer vertexConsumer, double d, double e, double f, double g, double h, double i, float j, float k, float l, float m) {
        ClientUtil.renderLineBox(poseStack, vertexConsumer, d, e, f, g, h, i, j, k, l, m, j, k, l);
    }

    public static void renderLineBox(PoseStack poseStack, VertexConsumer vertexConsumer, double d, double e, double f, double g, double h, double i, float j, float k, float l, float m, float n, float o, float p) {
        PoseStack.Pose pose = poseStack.last();
        float q = (float)d;
        float r = (float)e;
        float s = (float)f;
        float t = (float)g;
        float u = (float)h;
        float v = (float)i;
        vertexConsumer.addVertex(pose, q, r, s).setColor(j, o, p, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, r, s).setColor(j, o, p, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, r, s).setColor(n, k, p, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, u, s).setColor(n, k, p, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, r, s).setColor(n, o, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(pose, q, r, v).setColor(n, o, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(pose, t, r, s).setColor(j, k, l, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, u, s).setColor(j, k, l, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, u, s).setColor(j, k, l, m).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, u, s).setColor(j, k, l, m).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, u, s).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(pose, q, u, v).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(pose, q, u, v).setColor(j, k, l, m).setNormal(pose, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, r, v).setColor(j, k, l, m).setNormal(pose, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(pose, q, r, v).setColor(j, k, l, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, r, v).setColor(j, k, l, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, r, v).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, -1.0f);
        vertexConsumer.addVertex(pose, t, r, s).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, -1.0f);
        vertexConsumer.addVertex(pose, q, u, v).setColor(j, k, l, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, u, v).setColor(j, k, l, m).setNormal(pose, 1.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, r, v).setColor(j, k, l, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, u, v).setColor(j, k, l, m).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, t, u, s).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(pose, t, u, v).setColor(j, k, l, m).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void drawConfiguratorOverlay(GuiGraphics gr) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.screen != null) {
            return;
        }
        ItemStack is = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!is.is((Item)Content.invConfig.get())) {
            is = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (!is.is((Item)Content.invConfig.get())) {
            return;
        }
        ArrayList<MutableComponent> messages = new ArrayList<MutableComponent>();
        MutableComponent leftClk = Component.keybind((String)"key.attack").withStyle(ChatFormatting.GREEN);
        MutableComponent rightClk = Component.keybind((String)"key.use").withStyle(ChatFormatting.GREEN);
        MutableComponent shift = Component.keybind((String)"key.sneak").withStyle(ChatFormatting.GREEN);
        ConfiguratorComponent c = (ConfiguratorComponent)is.get(Content.configuratorComponent.get());
        if (c.isBound()) {
            int x = c.bound().getX();
            int y = c.bound().getY();
            int z = c.bound().getZ();
            BlockPos pos = new BlockPos(x, y, z);
            if (mc.player.distanceToSqr((double)x, (double)y, (double)z) < 4096.0) {
                ItemStack item;
                MutableComponent lookingAt = null;
                if (mc.hitResult != null && !(item = Platform.getCloneItemStack((Level)mc.level, pos, (Player)player)).isEmpty()) {
                    lookingAt = item.getHoverName();
                }
                if (lookingAt == null) {
                    lookingAt = Component.literal((String)"?");
                }
                if (mc.showOnlyReducedInfo()) {
                    messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.block_alt", (Object[])new Object[]{lookingAt}));
                } else {
                    messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.block", (Object[])new Object[]{x, y, z}));
                    messages.add(lookingAt);
                }
                if (c.selecting()) {
                    if (c.massSelect()) {
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.mass_select").withStyle(ChatFormatting.GOLD));
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.mass_select.finish", (Object[])new Object[]{leftClk}));
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.mass_select.abort", (Object[])new Object[]{shift, leftClk}));
                    } else {
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.select").withStyle(ChatFormatting.GOLD));
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.select.single", (Object[])new Object[]{rightClk}));
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.select.finish", (Object[])new Object[]{rightClk}));
                        messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.select.start_mass", (Object[])new Object[]{leftClk}));
                    }
                }
            } else {
                messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.too_far"));
            }
        } else {
            messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.configure", (Object[])new Object[]{rightClk}));
            messages.add(Component.translatable((String)"tooltip.toms_storage.config_overlay.show", (Object[])new Object[]{leftClk}));
        }
        if (!messages.isEmpty()) {
            gr.renderTooltip(mc.font, messages.stream().map(e -> ClientTooltipComponent.create((FormattedCharSequence)e.getVisualOrderText())).toList(), 5, 25, DefaultTooltipPositioner.INSTANCE, null);
        }
    }
}

