/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.client;

import com.tom.storagemod.block.entity.PaintedBlockEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;

public class BakedPaintedModel
implements DynamicBlockStateModel {
    private Block blockFor;
    private BlockStateModel parent;

    public BakedPaintedModel(Block blockFor, BlockStateModel parent) {
        this.blockFor = blockFor;
        this.parent = parent;
    }

    public TextureAtlasSprite particleIcon() {
        return this.parent.particleIcon();
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return this.parent.particleIcon(level, pos, state);
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        BlockStateModel model = null;
        Supplier blockstateSupp = (Supplier)level.getModelData(pos).get(PaintedBlockEntity.FACADE_STATE);
        BlockState blockstate = null;
        if (blockstateSupp != null) {
            blockstate = (BlockState)blockstateSupp.get();
        }
        if (blockstate == null || blockstate == Blocks.AIR.defaultBlockState()) {
            blockstate = state;
            model = this.parent;
        }
        if (model == null) {
            model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockstate);
        }
        if (model instanceof BakedPaintedModel) {
            return;
        }
        model.collectParts(level, pos, blockstate, random, parts);
    }
}

