/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Content;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.entity.StorageTerminalBlockEntity;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.CraftingTerminalMenu;
import com.tom.storagemod.polymorph.PolymorphHelper;
import com.tom.storagemod.util.CraftingMatrix;
import com.tom.storagemod.util.Util;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class CraftingTerminalBlockEntity
extends StorageTerminalBlockEntity {
    private Optional<RecipeHolder<CraftingRecipe>> currentRecipe = Optional.empty();
    private final CraftingContainer craftMatrix = new CraftingMatrix(3, 3, () -> {
        if (this.level != null && !this.level.isClientSide) {
            this.onCraftingMatrixChanged();
        }
        this.setChanged();
    });
    private ResultContainer craftResult = new ResultContainer();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean refillingGrid;
    private int craftingCooldown;
    private WeakReference<Player> polymorphPlayer;
    private boolean reading;

    public CraftingTerminalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.craftingTerminalBE.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu createMenu(int id, Inventory plInv, Player arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"menu.toms_storage.crafting_terminal");
    }

    @Override
    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        Util.storeItems((Container)this.craftMatrix, "CraftingTable", compound);
    }

    @Override
    public void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.reading = true;
        Util.loadItems((Container)this.craftMatrix, "CraftingTable", compound);
        this.reading = false;
    }

    public CraftingContainer getCraftingInv() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public void craft(Player thePlayer) {
        if (this.currentRecipe.isPresent()) {
            CraftingInput.Positioned craftinginput$positioned = this.craftMatrix.asPositionedCraftInput();
            CraftingInput craftinginput = craftinginput$positioned.input();
            NonNullList remainder = ((CraftingRecipe)this.currentRecipe.get().value()).getRemainingItems(craftinginput);
            boolean playerInvUpdate = false;
            this.refillingGrid = true;
            int x = craftinginput$positioned.left();
            int y = craftinginput$positioned.top();
            for (int k = 0; k < craftinginput.height(); ++k) {
                for (int l = 0; l < craftinginput.width(); ++l) {
                    int i = l + x + (k + y) * this.craftMatrix.getWidth();
                    ItemStack slot = this.craftMatrix.getItem(i);
                    ItemStack oldItem = slot.copy();
                    ItemStack rem = (ItemStack)remainder.get(l + k * craftinginput.width());
                    if (!slot.isEmpty()) {
                        this.craftMatrix.removeItem(i, 1);
                        slot = this.craftMatrix.getItem(i);
                    }
                    if (slot.isEmpty() && !oldItem.isEmpty()) {
                        StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1L);
                        if (is == null && (this.getModes() & 0x20) != 0) {
                            for (int j = 0; j < thePlayer.getInventory().getContainerSize(); ++j) {
                                ItemStack st = thePlayer.getInventory().getItem(j);
                                if (!ItemStack.isSameItemSameComponents((ItemStack)oldItem, (ItemStack)st) || (st = thePlayer.getInventory().removeItem(j, 1)).isEmpty()) continue;
                                is = new StoredItemStack(st, 1L);
                                playerInvUpdate = true;
                                break;
                            }
                        }
                        if (is != null) {
                            this.craftMatrix.setItem(i, is.getActualStack());
                            slot = this.craftMatrix.getItem(i);
                        }
                    }
                    if (rem.isEmpty()) continue;
                    if (slot.isEmpty()) {
                        this.craftMatrix.setItem(i, rem);
                        continue;
                    }
                    if ((rem = this.pushStack(rem)).isEmpty() || thePlayer.getInventory().add(rem)) continue;
                    thePlayer.drop(rem, false);
                }
            }
            this.refillingGrid = false;
            this.onCraftingMatrixChanged();
            this.craftingCooldown += this.craftResult.getItem(0).getCount();
            if (playerInvUpdate) {
                thePlayer.containerMenu.broadcastChanges();
            }
        }
    }

    public void unregisterCrafting(Player playerIn, CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
        if (this.polymorphPlayer != null && this.polymorphPlayer.get() == playerIn) {
            this.polymorphPlayer = null;
        }
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        if (this.refillingGrid) {
            return;
        }
        CraftingInput input = this.craftMatrix.asCraftInput();
        if (this.currentRecipe.isEmpty() || !((CraftingRecipe)this.currentRecipe.get().value()).matches((RecipeInput)input, this.level)) {
            this.currentRecipe = this.getRecipe(input);
        }
        if (this.currentRecipe.isEmpty()) {
            this.craftResult.setItem(0, ItemStack.EMPTY);
        } else {
            this.craftResult.setItem(0, ((CraftingRecipe)this.currentRecipe.get().value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess()));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        this.craftResult.setRecipeUsed((RecipeHolder)this.currentRecipe.orElse(null));
        if (!this.reading) {
            this.setChanged();
        }
    }

    private Optional<RecipeHolder<CraftingRecipe>> getRecipe(CraftingInput input) {
        if (StorageMod.polymorph && this.polymorphPlayer != null) {
            Player pl = (Player)this.polymorphPlayer.get();
            return PolymorphHelper.getRecipe(pl, (RecipeType<CraftingRecipe>)RecipeType.CRAFTING, input, this.level);
        }
        return this.level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, this.level);
    }

    public void clear(Player player) {
        for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
            StoredItemStack st0;
            ItemStack st = this.craftMatrix.removeItemNoUpdate(i);
            if (st.isEmpty() || (st0 = this.pushStack(new StoredItemStack(st))) == null) continue;
            ItemStack is = st0.getActualStack();
            player.getInventory().add(is);
            if (is.isEmpty()) continue;
            this.dropItem(is);
        }
        this.onCraftingMatrixChanged();
    }

    @Override
    public void updateServer() {
        super.updateServer();
        this.craftingCooldown = 0;
    }

    public boolean canCraft() {
        return this.craftingCooldown + this.craftResult.getItem(0).getCount() <= this.craftResult.getItem(0).getMaxStackSize();
    }

    public void polymorphUpdate(Player playerIn) {
        this.polymorphPlayer = new WeakReference<Player>(playerIn);
        this.currentRecipe = Optional.empty();
        this.onCraftingMatrixChanged();
    }

    public void setCraftSlot(int slot, ItemStack actualStack) {
        this.craftMatrix.setItem(slot, actualStack);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.craftMatrix);
    }
}

