/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractInventoryHopperBlock;
import com.tom.storagemod.block.entity.AbstractInventoryHopperBlockEntity;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.util.BlockFaceReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BasicInventoryHopperBlockEntity
extends AbstractInventoryHopperBlockEntity {
    private ItemStack filter = ItemStack.EMPTY;
    private int cooldown;
    private long topChange;
    private long bottomChange;
    public int waiting = 0;
    private ItemPredicate filterPred;
    private InventorySlot topSlot;

    public BasicInventoryHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.basicInvHopperBE.get(), pos, state);
    }

    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        ItemStack is = this.getFilter();
        if (!is.isEmpty()) {
            compound.store("Filter", ItemStack.CODEC, (Object)is);
        }
    }

    public void loadAdditional(ValueInput nbtIn) {
        super.loadAdditional(nbtIn);
        this.filter = nbtIn.read("Filter", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        if (this.filter.isEmpty()) {
            this.filterPred = null;
        } else {
            Item item = this.filter.getItem();
            if (item instanceof IItemFilter) {
                IItemFilter i = (IItemFilter)item;
                this.filterPred = i.createFilter(BlockFaceReference.touching(this.level, this.worldPosition, (Direction)this.getBlockState().getValue(AbstractInventoryHopperBlock.FACING)), filter);
            } else {
                this.filterPred = s -> ItemStack.isSameItemSameComponents((ItemStack)s.getStack(), (ItemStack)filter);
            }
        }
        this.waiting = 0;
        this.setChanged();
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    @Override
    public void updateServer() {
        boolean topWasNull;
        boolean hasFilter;
        if (!this.filter.isEmpty() && this.filterPred == null) {
            this.setFilter(this.filter);
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction facing = (Direction)state.getValue(AbstractInventoryHopperBlock.FACING);
        IInventoryAccess top = this.topCache.getAccess(this.level, this.worldPosition.relative(facing.getOpposite()));
        IInventoryAccess bottom = this.bottomCache.getAccess(this.level, this.worldPosition.relative(facing));
        boolean topNet = this.topCache.isNetwork();
        if (!this.topCache.isValid() || !this.bottomCache.isValid()) {
            return;
        }
        if (!topNet && !this.bottomCache.isNetwork()) {
            return;
        }
        int baseCd = Math.max(1, Config.get().basicHopperCooldown);
        int midCd = Math.max(1, baseCd * 4 / 10);
        int fastCd = Math.max(1, baseCd / 10);
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        boolean bl = hasFilter = this.filterPred != null;
        if (topNet && !hasFilter) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker tt = top.tracker();
        long t = tt.getChangeTracker(this.level);
        if (this.topChange != t) {
            this.topChange = t;
            this.waiting = 0;
            this.topSlot = null;
        } else {
            this.cooldown = midCd;
        }
        if (this.waiting == 1) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker bt = bottom.tracker();
        long b = bt.getChangeTracker(this.level);
        if (this.bottomChange != b) {
            this.bottomChange = b;
            this.waiting = 0;
        } else {
            this.cooldown = midCd;
        }
        if (this.waiting == 2) {
            return;
        }
        boolean bl2 = topWasNull = this.topSlot == null;
        if (hasFilter) {
            this.filterPred.updateState();
        }
        if (this.topSlot == null || this.waiting == 3) {
            this.topSlot = tt.findSlotAfter(this.topSlot, hasFilter ? this.filterPred : s -> true, false, true);
        }
        if (this.topSlot == null) {
            if (topWasNull) {
                this.waiting = 1;
                this.cooldown = baseCd;
            } else {
                this.cooldown = midCd;
            }
            return;
        }
        ItemStack is = this.topSlot.getStack();
        if (is.isEmpty()) {
            this.waiting = 3;
            this.cooldown = fastCd;
            return;
        }
        StoredItemStack st = new StoredItemStack(is);
        if (hasFilter && !this.filterPred.test(st)) {
            this.waiting = 3;
            this.cooldown = fastCd;
            return;
        }
        InventorySlot bottomSlot = bt.findSlotDest(st);
        if (bottomSlot == null) {
            this.waiting = 3;
            this.cooldown = baseCd;
            return;
        }
        if (this.topSlot.transferTo(1, bottomSlot)) {
            this.cooldown = baseCd;
        } else {
            this.waiting = 3;
            this.cooldown = baseCd;
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (!this.filter.isEmpty() && this.filter.getItem() instanceof IItemFilter) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.filter);
        }
    }
}

