/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.block.AbstractInventoryHopperBlock;
import com.tom.storagemod.block.entity.BasicInventoryHopperBlockEntity;
import com.tom.storagemod.item.IItemFilter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BasicInventoryHopperBlock
extends AbstractInventoryHopperBlock {
    public static final MapCodec<BasicInventoryHopperBlock> CODEC = BasicInventoryHopperBlock.simpleCodec(BasicInventoryHopperBlock::new);

    public BasicInventoryHopperBlock(BlockBehaviour.Properties pr) {
        super(pr);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BasicInventoryHopperBlockEntity(pos, state);
    }

    protected InteractionResult useItemOn(ItemStack is, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity te;
        if (is.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof BasicInventoryHopperBlockEntity) {
            BasicInventoryHopperBlockEntity h = (BasicInventoryHopperBlockEntity)te;
            if (!h.getFilter().isEmpty() && h.getFilter().getItem() instanceof IItemFilter) {
                BasicInventoryHopperBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)h.getFilter());
            }
            h.setFilter(is.copy());
            if (is.getItem() instanceof IItemFilter) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            Component txt = h.getFilter().getHoverName();
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.toms_storage.filter_item", (Object[])new Object[]{txt}), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof BasicInventoryHopperBlockEntity) {
            BasicInventoryHopperBlockEntity h = (BasicInventoryHopperBlockEntity)te;
            if (player.isShiftKeyDown()) {
                if (!h.getFilter().isEmpty() && h.getFilter().getItem() instanceof IItemFilter) {
                    player.getInventory().add(h.getFilter());
                }
                h.setFilter(ItemStack.EMPTY);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.toms_storage.filter_item", (Object[])new Object[]{Component.translatable((String)"tooltip.toms_storage.empty")}), true);
            } else {
                ItemStack s = h.getFilter();
                MutableComponent txt = s.isEmpty() ? Component.translatable((String)"tooltip.toms_storage.empty") : s.getHoverName();
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.toms_storage.filter_item", (Object[])new Object[]{txt}), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

