/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import java.util.Optional;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;

public class GoblinMerchantOffer
extends MerchantOffer {
    public GoblinMerchantOffer(MerchantOffer offer) {
        super(offer.getItemCostA(), offer.getItemCostB(), offer.getResult(), offer.getUses(), offer.getMaxUses(), offer.getDemand(), offer.getPriceMultiplier(), offer.getXp());
    }

    public GoblinMerchantOffer(ItemCost paymentStack, Optional<ItemCost> secondaryPaymentStack, ItemStack offerStack, int maxUses, int experience, float priceMultiplier) {
        super(paymentStack, secondaryPaymentStack, offerStack, maxUses, experience, priceMultiplier);
    }

    public boolean satisfiedBy(ItemStack primary, ItemStack secondary) {
        return this.isMatching(primary, Optional.of(this.getItemCostA())) && primary.getCount() >= this.getCostA().getCount() && this.isMatching(secondary, this.getItemCostB()) && secondary.getCount() >= this.getCostB().getCount();
    }

    private boolean isMatching(ItemStack given, Optional<ItemCost> costOptional) {
        ItemCost cost;
        if (costOptional.isEmpty() && given.isEmpty()) {
            return true;
        }
        if (costOptional.isEmpty()) {
            return true;
        }
        ItemStack givenCopy = given.copy();
        if (givenCopy.getMaxDamage() > 0) {
            givenCopy.setDamageValue(givenCopy.getDamageValue());
        }
        if (!givenCopy.is((cost = costOptional.get()).item())) {
            return false;
        }
        return cost.components().test((DataComponentGetter)givenCopy);
    }
}

