/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.goblintraders.client.renderer.entity.state.GoblinRenderState;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GoblinTraderModel
extends EntityModel<GoblinRenderState>
implements ArmedModel,
HeadedModel {
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart hood;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart nose;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart bag;

    public GoblinTraderModel(ModelPart part) {
        super(part);
        this.root = part;
        this.body = part.getChild("body");
        this.head = part.getChild("head");
        this.hood = this.head.getChild("hood");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.nose = this.head.getChild("nose");
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.bag = this.body.getChild("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(30, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)1.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.0f, (float)0.0f));
        body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(26, 9).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 9).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("bag", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -3.0f, 0.0f, 5.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-3.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(8, 8).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        head.addOrReplaceChild("hood", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -14.0f, -9.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)8.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)46, (int)46);
    }

    public void setupAnim(GoblinRenderState state) {
        super.setupAnim((EntityRenderState)state);
        float walkPos = state.walkAnimationPos;
        float walkSpeed = state.walkAnimationSpeed;
        if (!state.holdingItem) {
            this.rightArm.xRot = Mth.cos((float)(walkPos * 0.6662f + (float)Math.PI)) * 2.0f * walkSpeed * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(walkPos * 0.6662f)) * 2.0f * walkSpeed * 0.5f;
        }
        this.rightLeg.xRot = Mth.cos((float)(walkPos * 0.6662f)) * 1.4f * walkSpeed;
        this.leftLeg.xRot = Mth.cos((float)(walkPos * 0.6662f + (float)Math.PI)) * 1.4f * walkSpeed;
        this.rightArm.xRot -= (float)Math.toRadians(state.armAngle);
        this.leftArm.xRot -= (float)Math.toRadians(state.armAngle);
        Quaternionf quaternionYaw = new Quaternionf().rotationY(org.joml.Math.toRadians((float)state.yRot));
        Quaternionf quaternionPitch = new Quaternionf().rotationX(org.joml.Math.toRadians((float)state.xRot));
        Quaternionf quaternionRoll = new Quaternionf().rotationZ(org.joml.Math.toRadians((float)state.headTilt));
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)quaternionPitch).mul((Quaternionfc)quaternionYaw).mul((Quaternionfc)quaternionRoll);
        Vector3f euler = new Vector3f();
        finalRotation.getEulerAnglesZXY(euler);
        this.head.xRot = euler.x;
        this.head.yRot = euler.y;
        this.head.zRot = euler.z;
        if (state.attackTime > 0.0f) {
            ModelPart arm = this.rightArm;
            float progress = state.attackTime;
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)progress) * ((float)Math.PI * 2))) * 0.2f;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            progress = 1.0f - state.attackTime;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = Mth.sin((float)(progress * (float)Math.PI));
            float f3 = Mth.sin((float)(state.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            arm.xRot = (float)((double)arm.xRot - ((double)f2 * 1.2 + (double)f3));
            arm.yRot += this.body.yRot * 2.0f;
            arm.zRot += Mth.sin((float)(state.attackTime * (float)Math.PI)) * -0.4f;
        }
        if (state.sitting || state.usingItem) {
            this.rightLeg.xRot = (float)Math.toRadians(-90.0);
            this.rightLeg.yRot = (float)Math.toRadians(30.0);
            this.leftLeg.xRot = (float)Math.toRadians(-90.0);
            this.leftLeg.yRot = (float)Math.toRadians(-30.0);
            if (state.usingItem) {
                double rotateX = Math.toRadians(-90.0 + 5.0 * Math.sin(state.ageInTicks));
                this.rightArm.xRot = (float)rotateX;
                this.leftArm.xRot = (float)rotateX;
            }
        } else {
            this.rightLeg.yRot = (float)Math.toRadians(0.0);
            this.leftLeg.yRot = (float)Math.toRadians(0.0);
        }
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        switch (arm) {
            case LEFT: {
                this.body.translateAndRotate(poseStack);
                this.leftArm.translateAndRotate(poseStack);
                poseStack.translate(-0.235, -0.15, 0.25);
                poseStack.scale(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.body.translateAndRotate(poseStack);
                this.rightArm.translateAndRotate(poseStack);
                poseStack.translate(0.235, -0.15, 0.25);
                poseStack.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public ModelPart getHead() {
        return this.head;
    }
}

