/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Stairs
extends HorizontalDirectionalBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class);
    public static final VoxelShape N = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape E = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape S = Shapes.or((VoxelShape)Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape W = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape E_SIDE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)32.0, (double)16.0);
    public static final VoxelShape S_SIDE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape W_SIDE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape N_SIDE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)1.0);
    protected static final VoxelShape N_DUAL = Shapes.or((VoxelShape)N_SIDE, (VoxelShape[])new VoxelShape[]{S_SIDE, N});
    protected static final VoxelShape E_DUAL = Shapes.or((VoxelShape)E_SIDE, (VoxelShape[])new VoxelShape[]{W_SIDE, E});
    protected static final VoxelShape S_DUAL = Shapes.or((VoxelShape)N_SIDE, (VoxelShape[])new VoxelShape[]{S_SIDE, S});
    protected static final VoxelShape W_DUAL = Shapes.or((VoxelShape)E_SIDE, (VoxelShape[])new VoxelShape[]{W_SIDE, W});
    protected static final VoxelShape N_RIGHT = Shapes.or((VoxelShape)S_SIDE, (VoxelShape)N);
    protected static final VoxelShape E_RIGHT = Shapes.or((VoxelShape)W_SIDE, (VoxelShape)E);
    protected static final VoxelShape S_RIGHT = Shapes.or((VoxelShape)S_SIDE, (VoxelShape)S);
    protected static final VoxelShape W_RIGHT = Shapes.or((VoxelShape)W_SIDE, (VoxelShape)W);
    protected static final VoxelShape N_LEFT = Shapes.or((VoxelShape)N_SIDE, (VoxelShape)N);
    protected static final VoxelShape E_LEFT = Shapes.or((VoxelShape)E_SIDE, (VoxelShape)E);
    protected static final VoxelShape S_LEFT = Shapes.or((VoxelShape)N_SIDE, (VoxelShape)S);
    protected static final VoxelShape W_LEFT = Shapes.or((VoxelShape)E_SIDE, (VoxelShape)W);

    public Bridge_Stairs(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        Direction facing = (Direction)state.getValue(FACING);
        ConnectionStatus statetype = (ConnectionStatus)((Object)state.getValue(CONNECTION));
        switch (facing) {
            case NORTH: {
                switch (statetype.ordinal()) {
                    case 0: {
                        return N_DUAL;
                    }
                    case 1: {
                        return N;
                    }
                    case 2: {
                        return N_RIGHT;
                    }
                    case 3: {
                        return N_LEFT;
                    }
                }
            }
            case SOUTH: {
                switch (statetype.ordinal()) {
                    case 0: {
                        return S_DUAL;
                    }
                    case 1: {
                        return S;
                    }
                    case 2: {
                        return S_LEFT;
                    }
                    case 3: {
                        return S_RIGHT;
                    }
                }
            }
            case EAST: {
                switch (statetype.ordinal()) {
                    case 0: {
                        return E_DUAL;
                    }
                    case 1: {
                        return E;
                    }
                    case 2: {
                        return E_LEFT;
                    }
                    case 3: {
                        return E_RIGHT;
                    }
                }
            }
            case WEST: {
                switch (statetype.ordinal()) {
                    case 0: {
                        return W_DUAL;
                    }
                    case 1: {
                        return W;
                    }
                    case 2: {
                        return W_RIGHT;
                    }
                    case 3: {
                        return W_LEFT;
                    }
                }
            }
        }
        return N;
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        Direction facing = (Direction)state.getValue(FACING);
        switch (facing) {
            case NORTH: {
                return N;
            }
            case SOUTH: {
                return S;
            }
            case EAST: {
                return E;
            }
            case WEST: {
                return W;
            }
        }
        return N;
    }

    private BlockState StairState(BlockState state, LevelReader access, BlockPos pos) {
        BlockState northState = access.getBlockState(pos.north());
        BlockState eastState = access.getBlockState(pos.east());
        BlockState southState = access.getBlockState(pos.south());
        BlockState westState = access.getBlockState(pos.west());
        boolean north = northState.getBlock() == this;
        boolean east = eastState.getBlock() == this;
        boolean south = southState.getBlock() == this;
        boolean west = westState.getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.getValue(FACING), north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        boolean isConnectedNorthSouth = north && south;
        boolean isConnectedEastWest = east && west;
        switch (facing) {
            case NORTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (south) {
                    return ConnectionStatus.RIGHT;
                }
                if (north) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case SOUTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (north) {
                    return ConnectionStatus.RIGHT;
                }
                if (south) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case EAST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (west) {
                    return ConnectionStatus.RIGHT;
                }
                if (east) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case WEST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (east) {
                    return ConnectionStatus.RIGHT;
                }
                if (west) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
        }
        return ConnectionStatus.BASE;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.StairState(state, level, currentPos);
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        if (itemstack.getItem() instanceof BlockItem && (blockItem = (BlockItem)itemstack.getItem()).getBlock() == this) {
            Direction blockFacingDirection = (Direction)state.getValue(FACING);
            Direction facing = player.getDirection();
            BlockPos placePos = pos.relative(facing).above();
            if (level.getBlockState(placePos).isAir()) {
                level.setBlock(placePos, (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)blockFacingDirection), 3);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof Bridge_Stairs) {
            return null;
        }
        return (BlockState)this.StairState(super.getStateForPlacement(contx), (LevelReader)contx.getLevel(), contx.getClickedPos()).setValue(FACING, (Comparable)contx.getHorizontalDirection().getClockWise());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTION});
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        DOUBLE("double"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

