/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text.content;

import java.util.Optional;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedFormattedText;

public record ContentItemStack(ItemStack stack) implements AdvancedContent
{
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> consumer, Style style) {
        return this.stack.getHoverName().visit(consumer, style);
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> consumer) {
        return this.stack.getHoverName().visit(consumer);
    }

    @Override
    public int width(StringSplitter.WidthProvider widthProvider, Style style) {
        return 14;
    }

    @Override
    public int height() {
        return 8;
    }

    @Override
    public FormattedText asText() {
        return new ContentItemStackText(this);
    }

    public ComponentContents.Type<?> type() {
        return null;
    }

    private record ContentItemStackText(ContentItemStack content) implements AdvancedFormattedText
    {
        @Override
        public int width(StringSplitter.WidthProvider widthProvider, Style style) {
            return this.content.width(widthProvider, style);
        }

        @Override
        public int height() {
            return this.content.height();
        }

        @Override
        public void render(GuiGraphics graphics, int defaultColor) {
            Matrix3x2fStack pose = graphics.pose();
            pose.pushMatrix();
            pose.translate(0.0f, -2.0f);
            pose.scale(0.8f, 0.8f);
            graphics.renderItem(this.content.stack, 0, 0);
            pose.popMatrix();
        }
    }
}

