/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.parent;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.parent.GuiScrollX;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiClientScrollX<T extends GuiScrollX>
extends GuiClientParent<T>
implements GuiScrollX.GuiScrollXDist {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public boolean dragged;
    public int scrollbarHeight = 3;
    public boolean hoveredScroll;
    private int cachedWidth;

    public GuiClientScrollX(T control) {
        super(control);
    }

    @Override
    public void setHovered() {
        this.hoveredScroll = true;
    }

    @Override
    public void setHover(boolean hover) {
        this.hoveredScroll = hover;
    }

    @Override
    public double getOffsetX() {
        return -this.scrolled.current();
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scroll(scrolled);
        return true;
    }

    public void scroll(double scrolled) {
        this.scrolled.set(this.scrolled.aimed() - scrolled * 10.0);
        this.onScrolled();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0 && (double)this.rect.getHeight() - y <= (double)this.scrollbarHeight && this.needsScrollbar()) {
            this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.dragged = true;
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.dragged) {
            GuiStyle style = this.getStyle();
            ControlFormatting formatting = this.getControlFormatting();
            int completeWidth = this.rect.getWidth() - style.getBorder(formatting.border()) * 2;
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            double percent = x / (double)(completeWidth - scrollThingWidth);
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        super.mouseReleased(x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar() {
        return this.cachedWidth > this.rect.getContentWidth();
    }

    @Override
    protected void renderContent(GuiGraphics graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        super.renderContent(graphics, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        pose.popMatrix();
        if (!this.needsScrollbar() && this.hoveredScroll) {
            return;
        }
        float controlInvScale = (float)this.scaleFactorInv();
        pose.scale(controlInvScale, controlInvScale);
        GuiClientScrollX.scissor(graphics, realRect);
        GuiStyle style = this.getStyle();
        this.scrolled.tick();
        int completeWidth = this.rect.getWidth() - borderWidth * 2;
        int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
        if (scrollThingWidth > completeWidth) {
            scrollThingWidth = completeWidth;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        StyleDisplay display = this.hoveredScroll ? style.disabled : style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false);
        display.render(graphics, (int)(percent * (double)(completeWidth - scrollThingWidth)) + borderWidth, this.rect.getHeight() - borderWidth * this.scrollbarHeight - borderWidth, scrollThingWidth, this.scrollbarHeight);
        this.maxScroll = Math.max(0, this.cachedWidth - completeWidth + formatting.padding() * 2 + 1);
        float controlScale = (float)this.scaleFactor();
        pose.scale(controlScale, controlScale);
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 10;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    protected boolean endlessX() {
        return true;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        this.cachedWidth = width;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        if (!this.hoveredScroll) {
            height -= this.scrollbarHeight;
        }
        super.flowY(width, height, preferred);
    }
}

