/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.client.gui.control.collection.GuiClientStackSelector;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollY;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGridPreview;
import team.creative.creativecore.common.gui.control.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiClientStackSelectorExtension<T extends GuiStackSelectorExtension>
extends GuiClientScrollY<T>
implements GuiStackSelectorExtension.GuiStackSelectorExtensionDist {
    private GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator;
    private String search = "";
    protected int cachedWidth;

    public GuiClientStackSelectorExtension(T control) {
        super(control);
        ((GuiParent)control).registerEventChanged(x -> {
            if (x.control.is("searchBar")) {
                this.search = ((GuiTextfield)x.control).getText();
                this.reloadControls();
            }
        });
        ((GuiParent)control).registerEventClick(event -> {
            if (event.control instanceof GuiSlotViewer && event.control.isParent((IGuiParent)control)) {
                ((GuiClientStackSelector)this.creator.parent).setSelected(((GuiSlotViewer)event.control).getStack(), true);
                this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
                this.creator.close();
            }
        });
    }

    public void init(GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator) {
        this.creator = creator;
        this.reloadControls();
    }

    public GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator() {
        return this.creator;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        super.mouseClicked(x, y, button);
        this.creator.markKeptFocus();
        return true;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width;
        super.flowX(width, preferred);
    }

    @Override
    public void reflowInternal() {
        this.flowX(this.cachedWidth, this.preferredWidth(this.cachedWidth));
        this.flowY(this.cachedWidth, this.cachedHeight, this.preferredHeight(this.cachedWidth, this.cachedHeight));
    }

    public void reloadControls() {
        HashMapList<String, ItemStack> stacks;
        if (this.creator == null) {
            return;
        }
        GuiClientStackSelector comboBox = (GuiClientStackSelector)this.creator.parent;
        HashMapList<String, ItemStack> hashMapList = stacks = this.search == null || this.search.isEmpty() ? comboBox.getStacks() : new HashMapList<String, ItemStack>();
        if (this.search != null && !this.search.isEmpty()) {
            for (Map.Entry<String, ArrayList<ItemStack>> entry : comboBox.getStacks().entrySet()) {
                for (ItemStack stack : entry.getValue()) {
                    if (!GuiStackSelector.contains(this.search, stack)) continue;
                    stacks.add(entry.getKey(), stack);
                }
            }
        }
        GuiTextfield textfield = (GuiTextfield)((GuiStackSelectorExtension)this.control).get("searchBar");
        ((GuiStackSelectorExtension)this.control).clear();
        if (comboBox.hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield((IGuiParent)((Object)this.control), "searchBar", this.search == null ? "" : this.search);
            }
            ((GuiStackSelectorExtension)this.control).add(textfield.setExpandableX());
            textfield.dist().focus();
        }
        for (Map.Entry entry : stacks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ((GuiStackSelectorExtension)this.control).add((GuiControl)new GuiLabel((IGuiParent)((Object)this.control), "title").setTitle((Component)Component.translatable((String)((String)entry.getKey()))));
            SimpleContainer container = new SimpleContainer(entry.getValue().size());
            int i = 0;
            for (ItemStack stack : entry.getValue()) {
                container.setItem(i, stack);
                ++i;
            }
            ((GuiStackSelectorExtension)this.control).add((GuiControl)new GuiInventoryGridPreview((IGuiParent)((Object)this.control), (String)entry.getKey(), (Container)container));
        }
        if (((GuiStackSelectorExtension)this.control).hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public void looseFocus() {
        this.creator.markLostFocus();
    }
}

