/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.client.gui.control.collection.GuiClientStackSelectorExtension;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabel;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiClientStackSelector<T extends GuiStackSelector>
extends GuiClientLabel<T>
implements GuiStackSelector.GuiStackSelectorDist {
    protected GuiExtensionCreator<GuiClientStackSelector, GuiStackSelectorExtension> ex = new GuiExtensionCreator(this);
    protected GuiStackSelector.StackCollector collector;
    protected HashMapList<String, ItemStack> stacks;
    protected ItemStack selected = ItemStack.EMPTY;
    private boolean searchbar;

    public GuiClientStackSelector(T control) {
        super(control);
    }

    @Override
    public void setCollector(GuiStackSelector.StackCollector collector) {
        this.collector = collector;
    }

    @Override
    public boolean hasSearchbar() {
        return this.searchbar;
    }

    @Override
    public void setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
    }

    @Override
    public boolean selectFirst(boolean notify) {
        ItemStack first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first, notify);
            return true;
        }
        return false;
    }

    @Override
    public void updateCollectedStacks(boolean notify) {
        this.stacks = this.collector.collect(((GuiStackSelector)this.control).getPlayer());
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    public boolean setSelectedForce(ItemStack stack, boolean notify) {
        this.setTitle(new TextBuilder().stack(stack).add(stack.getHoverName()).build());
        this.selected = stack;
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
        return true;
    }

    @Override
    public boolean setSelected(ItemStack stack, boolean notify) {
        if (this.stacks.contains(stack)) {
            this.setTitle(new TextBuilder().stack(stack).add(stack.getHoverName()).build());
            this.selected = stack;
            if (notify) {
                this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
            }
            return true;
        }
        return false;
    }

    @Override
    public HashMapList<String, ItemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public ItemStack getSelected() {
        return this.selected;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        this.ex.toggle(this::createBox);
        this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        return true;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    protected GuiStackSelectorExtension createBox(GuiExtensionCreator<GuiClientStackSelector, GuiStackSelectorExtension> creator) {
        GuiStackSelectorExtension ex = new GuiStackSelectorExtension(((GuiStackSelector)this.control).getParent(), ((GuiStackSelector)this.control).name + "extension");
        ((GuiClientStackSelectorExtension)ex.dist()).init(creator);
        return ex;
    }

    @Override
    public void looseFocus() {
        if (this.ex.checkShouldClose()) {
            this.ex.close();
        }
    }
}

