/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui;

import java.util.ListIterator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControls;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.event.GuiControlClickEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiClientParent<T extends GuiParent>
extends GuiClientControl<T>
implements GuiParent.GuiParentDistHandler {
    public GuiFlow flow;
    public Align align = Align.LEFT;
    public VAlign valign = VAlign.TOP;
    public int spacing = 2;
    private double scale = 1.0;
    private double scaleInv = 1.0;
    private GuiControls controls;

    public GuiClientParent(T control) {
        super(control);
    }

    @Override
    public void initControlList(GuiControls controls) {
        this.controls = controls;
    }

    public Iterable<GuiClientControl> controls() {
        return this.controls.distControls();
    }

    public Iterable<GuiClientControl> hoverControls() {
        return this.controls.distHoverControls();
    }

    public Iterable<GuiClientControl> all() {
        return this.controls.distAll();
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
        this.scaleInv = 1.0 / scale;
    }

    public final double scaleFactor() {
        return this.scale;
    }

    public final double scaleFactorInv() {
        return this.scaleInv;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public double getOffsetX() {
        return 0.0;
    }

    @Override
    public void setAlign(Align align) {
        this.align = align;
    }

    @Override
    public void setVAlign(VAlign valign) {
        this.valign = valign;
    }

    @Override
    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public void setFlow(GuiFlow flow) {
        this.flow = flow;
    }

    protected void renderControls(GuiGraphics graphics, Rect contentRect, Rect realContentRect, int mouseX, int mouseY, ListIterator<GuiClientControl> collection, double scale, double xOffset, double yOffset, boolean hover) {
        Matrix3x2fStack pose = graphics.pose();
        while (collection.hasPrevious()) {
            Rect controlContentRect;
            Rect realRect;
            GuiClientControl control = collection.previous();
            if (!control.visible || (realRect = realContentRect.intersection(controlContentRect = control.createChildRect(contentRect, scale, xOffset, yOffset))) == null && !hover) continue;
            if (hover) {
                GuiClientParent.scissor(graphics, null);
            } else {
                GuiClientParent.scissor(graphics, realRect);
            }
            pose.pushMatrix();
            pose.translate((float)((double)control.rect.getX() + xOffset), (float)((double)control.rect.getY() + yOffset));
            this.renderControl(graphics, control, controlContentRect, realRect, scale, mouseX, mouseY, hover);
            pose.popMatrix();
        }
    }

    protected void renderControl(GuiGraphics graphics, GuiClientControl control, Rect controlContentRect, Rect realRect, double scale, int mouseX, int mouseY, boolean hover) {
        control.render(graphics, controlContentRect, hover ? controlContentRect : realRect, scale, mouseX, mouseY);
    }

    @Override
    protected void renderContent(GuiGraphics graphics, Rect contentRect, Rect realContentRect, double scale, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        Matrix3x2fStack pose = graphics.pose();
        float controlScale = (float)this.scaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        pose.scale(controlScale, controlScale);
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, this.controls.distListControls(this.controls.controlSize()), scale *= this.scaleFactor(), xOffset, yOffset, false);
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, this.controls.distHoverListControls(this.controls.hoverSize()), scale, xOffset, yOffset, true);
        super.renderContent(graphics, contentRect, realContentRect, scale, mouseX, mouseY);
    }

    @Override
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public boolean isMouseOverHovered(double x, double y) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.hoverControls()) {
            if (!control.rect.inside(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GuiTooltipEvent getTooltipEvent(double x, double y) {
        GuiTooltipEvent event = super.getTooltipEvent(x, y);
        if (event != null) {
            return event;
        }
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.rect.inside(x, y) || (event = control.getTooltipEvent(x - (double)control.rect.getX(), y - (double)control.rect.getY())) == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public boolean testForDoubleClick(double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.rect.inside(x, y) || !control.testForDoubleClick(x - (double)control.rect.getX(), y - (double)control.rect.getY(), button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double x, double y) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable()) continue;
            control.mouseMoved(x - (double)control.rect.getX(), y - (double)control.rect.getY());
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiClientControl control : this.all()) {
            if (!result && control.isInteractable() && control.rect.inside(x, y) && control.mouseClicked(x - (double)control.rect.getX(), y - (double)control.rect.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent((GuiControl)control.control, button, false));
                result = true;
                continue;
            }
            control.looseFocus();
        }
        return result;
    }

    @Override
    public boolean mouseDoubleClicked(double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiClientControl control : this.all()) {
            if (!result && control.isInteractable() && control.rect.inside(x, y) && control.mouseDoubleClicked(x - (double)control.rect.getX(), y - (double)control.rect.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent((GuiControl)control.control, button, false));
                result = true;
                continue;
            }
            control.looseFocus();
        }
        return result;
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable()) continue;
            control.mouseReleased(x - (double)control.rect.getX(), y - (double)control.rect.getY(), button);
        }
    }

    @Override
    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable()) continue;
            control.mouseDragged(x - (double)control.rect.getX(), y - (double)control.rect.getY(), button, dragX, dragY, time);
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        x *= this.scaleFactorInv();
        y *= this.scaleFactorInv();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.rect.inside(x, y) || !control.mouseScrolled(x - (double)control.rect.getX(), y - (double)control.rect.getY(), delta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        for (GuiClientControl control : this.all()) {
            if (!control.isInteractable() || !control.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void looseFocus() {
        for (GuiClientControl control : this.all()) {
            control.looseFocus();
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        this.flow.flowX(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, this.align, width, preferred, this.endlessX());
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        this.flow.flowY(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, this.valign, width, height, preferred, this.endlessY());
    }

    protected boolean endlessX() {
        return false;
    }

    protected boolean endlessY() {
        return false;
    }

    @Override
    protected int minWidth(int availableWidth) {
        return Mth.ceil((double)((double)this.flow.minWidth(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, availableWidth) * this.scale));
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return Mth.ceil((double)((double)this.flow.preferredWidth(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, availableWidth) * this.scale));
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return Mth.ceil((double)((double)this.flow.minHeight(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, width, availableHeight) * this.scale));
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return Mth.ceil((double)((double)this.flow.preferredHeight(this.controls.streamDistControls().map(x -> ((GuiClientControl)x).rect).toList(), this.spacing, width, availableHeight) * this.scale));
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @Override
    public void applyOffset(GuiControl control, Rect rect) {
        rect.move((double)((GuiClientControl)control.dist()).rect.getX() + this.getOffsetX() + (double)this.getContentOffset(), (double)((GuiClientControl)control.dist()).rect.getY() + this.getOffsetY() + (double)this.getContentOffset());
        rect.scale(this.scaleFactor());
    }
}

