/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.ControlFormattingFlexible;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;

public abstract class GuiClientControl<T extends GuiControl>
implements GuiControlDistHandler {
    public final GuiControlRect rect = new GuiControlRect(this);
    public final T control;
    public boolean enabled = true;
    public boolean visible = true;
    public GuiSizeRule preferred;
    public boolean expandableX = false;
    public boolean expandableY = false;
    private List<Component> customTooltip;
    private ControlFormatting customFormatting;

    public static Rect getScreenRect() {
        Minecraft mc = Minecraft.getInstance();
        return new Rect(0.0, 0.0, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
    }

    public static void scissor(GuiGraphics graphics, @Nullable Rect rect) {
        if (rect == null) {
            ((CreativeGuiGraphics)graphics).setOverrideScissor(null);
            return;
        }
        ((CreativeGuiGraphics)graphics).setOverrideScissor(new ScreenRectangle((int)Math.floor(rect.minX), (int)Math.floor(rect.minY), (int)Math.ceil(rect.getWidth()), (int)Math.ceil(rect.getHeight()) + 1));
    }

    public GuiClientControl(T control) {
        this.control = control;
    }

    @Nullable
    public GuiClientControl getParent() {
        IGuiParent iGuiParent = ((GuiControl)this.control).getParent();
        if (iGuiParent instanceof GuiControl) {
            GuiControl c = (GuiControl)((Object)iGuiParent);
            return (GuiClientControl)c.dist();
        }
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setFixed() {
        this.expandableX = false;
        this.expandableY = false;
    }

    @Override
    public void setFixedX() {
        this.expandableX = false;
    }

    @Override
    public void setFixedY() {
        this.expandableY = false;
    }

    @Override
    public void setExpandable() {
        this.expandableX = true;
        this.expandableY = true;
    }

    @Override
    public void setExpandableX() {
        this.expandableX = true;
    }

    @Override
    public void setExpandableY() {
        this.expandableY = true;
    }

    @Override
    public void setDim(int width, int height) {
        this.preferred = new GuiSizeRule.GuiFixedDimension(width, height);
    }

    @Override
    public void setDim(GuiSizeRule dim) {
        this.preferred = dim;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void removeFormatting() {
        this.customFormatting = null;
    }

    @Override
    public void setFormatting(ControlFormatting formatting) {
        this.customFormatting = formatting;
    }

    @Override
    public ControlFormattingFlexible setCustomFormatting() {
        this.customFormatting = new ControlFormattingFlexible.ControlFormattingFlexibleImpl(this.getControlFormatting());
        return (ControlFormattingFlexible)this.customFormatting;
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    @Override
    public boolean isExpandableY() {
        return this.expandableY;
    }

    public GuiStyle getStyle() {
        IGuiParent iGuiParent = ((GuiControl)this.control).getParent();
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return ((GuiClientControl)control.dist()).getStyle();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public void raiseEvent(GuiEvent event) {
        ((GuiControl)this.control).raiseEvent(event);
    }

    public Rect createChildRect(Rect contentRect, double scale, double xOffset, double yOffset) {
        return contentRect.child(this.rect, scale, xOffset, yOffset);
    }

    protected abstract void flowX(int var1, int var2);

    protected abstract void flowY(int var1, int var2, int var3);

    protected int minWidth(int availableWidth) {
        return -1;
    }

    protected abstract int preferredWidth(int var1);

    protected int maxWidth(int availableWidth) {
        return -1;
    }

    protected int minHeight(int width, int availableHeight) {
        return -1;
    }

    protected abstract int preferredHeight(int var1, int var2);

    protected int maxHeight(int width, int availableHeight) {
        return -1;
    }

    public boolean testForDoubleClick(double x, double y, int button) {
        return false;
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public void mouseMoved(double x, double y) {
    }

    public boolean mouseClicked(double x, double y, int button) {
        return false;
    }

    public boolean mouseDoubleClicked(double x, double y, int button) {
        return this.mouseClicked(x, y, button);
    }

    public void mouseReleased(double x, double y, int button) {
    }

    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    public void looseFocus() {
    }

    protected abstract ControlFormatting defaultFormatting();

    public ControlFormatting getControlFormatting() {
        if (this.customFormatting != null) {
            return this.customFormatting;
        }
        return this.defaultFormatting();
    }

    public int getContentOffset() {
        return this.getStyle().getContentOffset(this.getControlFormatting());
    }

    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return display;
    }

    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return display;
    }

    public void render(GuiGraphics graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(Minecraft.getInstance().getMainRenderTarget().getDepthTexture(), 1.0);
        Rect rectCopy = null;
        if (!this.enabled) {
            rectCopy = controlRect.copy();
        }
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        GuiStyle style = this.getStyle();
        ControlFormatting formatting = this.getControlFormatting();
        this.getBorder(style, style.get(formatting.border())).render(graphics, 0.0, 0.0, width, height);
        int borderSize = style.getBorder(formatting.border());
        this.getBackground(style, style.get(formatting.face(), this.enabled && realRect.inside(mouseX, mouseY))).render(graphics, borderSize, borderSize, width -= borderSize * 2, height -= borderSize * 2);
        controlRect.shrink((double)borderSize * scale);
        this.renderContent(graphics, formatting, borderSize, controlRect, realRect, scale, mouseX, mouseY);
        if (!this.enabled && formatting.hasDisabledEffect()) {
            GuiClientControl.scissor(graphics, realRect);
            style.disabled.render(graphics, null, rectCopy);
        }
    }

    protected void renderContent(GuiGraphics graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        controlRect.shrink((double)formatting.padding() * scale);
        if (!this.enabled) {
            pose.pushMatrix();
        }
        pose.translate((float)(borderWidth + formatting.padding()), (float)(borderWidth + formatting.padding()));
        Rect r = controlRect.intersection(realRect);
        if (r != null) {
            this.renderContent(graphics, controlRect, r, scale, mouseX, mouseY);
        }
        if (!this.enabled) {
            pose.popMatrix();
        }
    }

    protected void renderContent(GuiGraphics graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        this.renderContent(graphics, mouseX, mouseY);
    }

    protected abstract void renderContent(GuiGraphics var1, int var2, int var3);

    public List<Component> getTooltip() {
        return this.customTooltip;
    }

    public GuiTooltipEvent getTooltipEvent(double x, double y) {
        String langTooltip;
        List<Component> toolTip = this.getTooltip();
        if (this.customTooltip != null) {
            if (toolTip == null) {
                toolTip = this.customTooltip;
            } else if (toolTip != this.customTooltip) {
                toolTip.addAll(this.customTooltip);
            }
        }
        if (toolTip == null && (langTooltip = GuiControl.translateOrDefault(((GuiControl)this.control).getNestedName() + ".tooltip", null)) != null) {
            toolTip = new TextBuilder(langTooltip).build();
        }
        if (toolTip != null) {
            return new GuiTooltipEvent((GuiControl)this.control, toolTip);
        }
        return null;
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.customTooltip = tooltip != null && tooltip.isEmpty() ? null : tooltip;
    }

    @Override
    public void setTooltip(String translate) {
        this.setTooltip(new TextBuilder().translate(translate).build());
    }

    public void playSound(SoundInstance sound) {
        Minecraft.getInstance().getSoundManager().play(sound);
    }

    @Override
    public void playSound(Holder.Reference<SoundEvent> sound) {
        this.playSound((SoundEvent)sound.value());
    }

    @Override
    public void playSound(SoundEvent event) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)1.0f));
    }

    @Override
    public void playSound(SoundEvent event, float volume, float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)pitch, (float)volume));
    }

    @Override
    public void playSound(Holder.Reference<SoundEvent> event, float volume, float pitch) {
        this.playSound((SoundEvent)event.value(), volume, pitch);
    }
}

