/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.util.EnchantToolUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Archivist
extends SpellcasterIllager {
    private AbstractIllager enchantTarget;
    private int levitateTargetsCooldown;
    private int enchantAlliesCooldown;

    public Archivist(EntityType<? extends Archivist> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(3, (Goal)new EnchantAllyGoal());
        this.goalSelector.addGoal(4, (Goal)new LevitateTargetsGoal());
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSoundEvents.ARCHIVIST_AMBIENT_SOUND_EVENT.value();
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        --this.levitateTargetsCooldown;
        --this.enchantAlliesCooldown;
        super.customServerAiStep(serverLevel);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ARCHIVIST_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ARCHIVIST_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.ARCHIVIST_HURT_SOUND_EVENT.value();
    }

    @Nullable
    AbstractIllager getEnchantTarget() {
        return this.enchantTarget;
    }

    void setEnchantTarget(@Nullable AbstractIllager entity) {
        this.enchantTarget = entity;
    }

    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSoundEvents.SORCERER_COMPLETE_CAST_SOUND_EVENT.value();
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public class EnchantAllyGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeEnchantableMobPredicate;
        private int targetId;

        public EnchantAllyGoal() {
            super((SpellcasterIllager)Archivist.this);
            this.closeEnchantableMobPredicate = TargetingConditions.forNonCombat().range(16.0).selector((livingEntity, serverLevel) -> !(livingEntity instanceof Archivist));
        }

        public boolean canEnchant() {
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            return hostileEntity != null && EnchantToolUtil.eligibleForEnchant((LivingEntity)hostileEntity);
        }

        public boolean canUse() {
            if (Archivist.this.getTarget() == null) {
                return false;
            }
            if (Archivist.this.enchantAlliesCooldown >= 0) {
                return false;
            }
            if (Archivist.this.isCastingSpell()) {
                return false;
            }
            List list = ((ServerLevel)Archivist.this.level()).getNearbyEntities(AbstractIllager.class, this.closeEnchantableMobPredicate, (LivingEntity)Archivist.this, Archivist.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Archivist.this.setEnchantTarget((AbstractIllager)list.get(Archivist.this.random.nextInt(list.size())));
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            if (hostileEntity.getId() == this.targetId) {
                return false;
            }
            return this.canEnchant();
        }

        public void stop() {
            super.stop();
            Archivist.this.setEnchantTarget(null);
        }

        protected void performSpellCasting() {
            AbstractIllager hostileEntity = Archivist.this.getEnchantTarget();
            if (hostileEntity != null) {
                this.targetId = hostileEntity.getId();
            }
            EnchantToolUtil.enchantHeldGear((LivingEntity)hostileEntity);
            double x = hostileEntity.getX();
            double y = hostileEntity.getY() + 1.5;
            double z = hostileEntity.getZ();
            if (Archivist.this.level() instanceof ServerLevel) {
                ((ServerLevel)Archivist.this.level()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 50, 1.0, 2.0, 1.0, 0.1);
            }
            Archivist.this.enchantAlliesCooldown = 300;
        }

        protected int getCastWarmupTime() {
            return 50;
        }

        protected int getCastingTime() {
            return 50;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.SORCERER_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    public class LevitateTargetsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public LevitateTargetsGoal() {
            super((SpellcasterIllager)Archivist.this);
        }

        public boolean canUse() {
            if (Archivist.this.getTarget() == null) {
                return false;
            }
            return Archivist.this.levitateTargetsCooldown < 0 && !this.getTargets().isEmpty();
        }

        private void knockBack(Entity entity) {
            double d = entity.getX() - Archivist.this.getX();
            double e = entity.getZ() - Archivist.this.getZ();
            double f = Math.max(d * d + e * e, 0.001);
            entity.push(d / f * 5.0, 0.6, e / f * 5.0);
        }

        protected void knockback(LivingEntity target) {
            this.knockBack((Entity)target);
            target.hurtMarked = true;
        }

        private List<LivingEntity> getTargets() {
            return Archivist.this.level().getEntitiesOfClass(LivingEntity.class, Archivist.this.getBoundingBox().inflate(6.0), entity -> !(entity instanceof Monster) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity));
        }

        protected void performSpellCasting() {
            Archivist.this.levitateTargetsCooldown = 220;
            this.getTargets().forEach(this::buff);
            double x = Archivist.this.getX();
            double y = Archivist.this.getY() + 1.0;
            double z = Archivist.this.getZ();
            ((ServerLevel)Archivist.this.level()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 150, 3.0, 3.0, 3.0, 0.1);
        }

        private void buff(LivingEntity entity) {
            this.knockback(entity);
            entity.hurtServer((ServerLevel)Archivist.this.level(), Archivist.this.damageSources().indirectMagic((Entity)Archivist.this, (Entity)Archivist.this), 4.0f);
        }

        protected int getCastWarmupTime() {
            return 50;
        }

        protected int getCastingTime() {
            return 50;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.ILLUSIONER_PREPARE_BLINDNESS;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }
}

