/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.util;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;

public class FireworksShootingHelper {
    public static boolean performShooting(LivingEntity shooter, LivingEntity target) {
        ItemStack itemStack = FireworksShootingHelper.createLoadedWeapon();
        if (itemStack.isEmpty()) {
            return false;
        }
        Difficulty difficulty = shooter.level().getDifficulty();
        float inaccuracy = FireworksShootingHelper.getInaccuracyForDifficulty(difficulty);
        ((CrossbowItem)Items.CROSSBOW).performShooting(shooter.level(), shooter, InteractionHand.MAIN_HAND, itemStack, 1.6f, inaccuracy, target);
        return true;
    }

    private static int getInaccuracyForDifficulty(Difficulty difficulty) {
        return 14 - difficulty.getId() * 4;
    }

    private static ItemStack createLoadedWeapon() {
        ItemStack fireworksItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        Fireworks fireworks = FireworksShootingHelper.createFireworks(1, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.GREEN);
        fireworksItem.set(DataComponents.FIREWORKS, (Object)fireworks);
        ItemStack weaponItem = new ItemStack((ItemLike)Items.CROSSBOW);
        weaponItem.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)fireworksItem));
        return weaponItem;
    }

    private static Fireworks createFireworks(int flightDuration, DyeColor ... dyeColors) {
        List<FireworkExplosion> fireworkExplosions = Arrays.stream(dyeColors).map(FireworksShootingHelper::createFireworkExplosion).toList();
        return new Fireworks(flightDuration, fireworkExplosions);
    }

    private static FireworkExplosion createFireworkExplosion(DyeColor dyeColor) {
        IntList intList = IntLists.singleton((int)dyeColor.getFireworkColor());
        return new FireworkExplosion(FireworkExplosion.Shape.LARGE_BALL, intList, intList, false, false);
    }
}

