/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.illagerinvasion.client.render.entity.state.ThrownHatchetRenderState;
import fuzs.illagerinvasion.world.entity.projectile.ThrownHatchet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.state.ThrownItemRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class ThrownHatchetRenderer
extends ThrownItemRenderer<ThrownHatchet> {
    private final ItemModelResolver itemModelResolver;

    public ThrownHatchetRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(ThrownItemRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(1.45f, 1.45f, 1.45f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(((ThrownHatchetRenderState)renderState).yRot + 90.0f));
        float rotation = ((ThrownHatchetRenderState)renderState).isInGround ? 1.0f : renderState.ageInTicks;
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(((ThrownHatchetRenderState)renderState).xRot + 90.0f * rotation));
        poseStack.translate(0.1f, -0.2f, 0.0f);
        renderState.item.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ThrownItemRenderState createRenderState() {
        return new ThrownHatchetRenderState();
    }

    public void extractRenderState(ThrownHatchet entity, ThrownItemRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, reusedState, partialTick);
        ((ThrownHatchetRenderState)reusedState).yRot = entity.getYRot(partialTick);
        ((ThrownHatchetRenderState)reusedState).xRot = entity.getXRot(partialTick);
        if (entity.isFoil()) {
            ItemStack itemStack = entity.getItem().copy();
            itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            this.itemModelResolver.updateForNonLiving(reusedState.item, itemStack, ItemDisplayContext.GROUND, (Entity)entity);
        }
        ((ThrownHatchetRenderState)reusedState).isInGround = entity.isInGround();
    }
}

