/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.init.ModelLayerLocations;
import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.render.entity.state.SpellcasterIllagerRenderState;
import fuzs.illagerinvasion.world.entity.monster.Archivist;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.joml.Quaternionfc;

public class ArchivistRenderer
extends IllagerRenderer<Archivist, SpellcasterIllagerRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/archivist.png");
    private static final Material BOOK_LOCATION = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocationHelper.withDefaultNamespace((String)"entity/enchanting_table_book"));

    public ArchivistRenderer(final EntityRendererProvider.Context context) {
        super(context, new CustomIllagerModel(context.bakeLayer(ModelLayerLocations.ARCHIVIST)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer<SpellcasterIllagerRenderState, IllagerModel<SpellcasterIllagerRenderState>>(this, (RenderLayerParent)this){
            private final BookModel book;
            {
                super(renderer);
                this.book = new BookModel(context.bakeLayer(ModelLayerLocations.ARCHIVIST_BOOK));
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, SpellcasterIllagerRenderState renderState, float yRot, float xRot) {
                if (renderState.isCastingSpell) {
                    super.render(poseStack, bufferSource, packedLight, (ArmedEntityRenderState)renderState, yRot, xRot);
                }
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.362f, -0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                if (renderState.isCastingSpell) {
                    poseStack.translate(-0.4f, 0.0f, 0.0f);
                    this.book.setupAnim(0.0f, 10.0f + Mth.cos((float)renderState.ageInTicks) * 0.55f, 0.0f, 1.05f);
                    poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(30.0f));
                } else {
                    this.book.setupAnim(0.0f, 0.0f, 0.0f, 0.0f);
                }
                VertexConsumer vertexConsumer = BOOK_LOCATION.buffer(bufferSource, RenderType::entitySolid);
                this.book.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public SpellcasterIllagerRenderState createRenderState() {
        return new SpellcasterIllagerRenderState();
    }

    public void extractRenderState(Archivist entity, SpellcasterIllagerRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractIllager)entity, (IllagerRenderState)reusedState, partialTick);
        reusedState.isCastingSpell = entity.isCastingSpell();
    }

    public ResourceLocation getTextureLocation(SpellcasterIllagerRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

