/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import terrablender.api.RegionType;
import terrablender.core.TerraBlender;
import terrablender.util.WeightedEntry;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer0;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.BiomeInitialLayer;
import terrablender.worldgen.noise.InitialLayer;
import terrablender.worldgen.noise.ZoomLayer;

public class LayeredNoiseUtil {
    public static Area uniqueness(RegistryAccess registryAccess, RegionType regionType, long seed) {
        return LayeredNoiseUtil.finalUniqueness(regionType, seed, LayeredNoiseUtil.initialUniqueness(registryAccess, regionType));
    }

    public static InitialLayer initialUniqueness(RegistryAccess registryAccess, RegionType regionType) {
        return new InitialLayer(registryAccess, regionType);
    }

    public static Area finalUniqueness(RegionType regionType, long seed, InitialLayer initialLayer) {
        int numZooms = TerraBlender.CONFIG.overworldRegionSize;
        if (regionType == RegionType.NETHER) {
            numZooms = TerraBlender.CONFIG.netherRegionSize;
        }
        return LayeredNoiseUtil.createZoomedArea(seed, numZooms, initialLayer);
    }

    public static Area biomeArea(RegistryAccess registryAccess, long seed, int size, List<WeightedEntry.Wrapper<ResourceKey<Biome>>> entries) {
        return LayeredNoiseUtil.createZoomedArea(seed, size, new BiomeInitialLayer(registryAccess, entries));
    }

    public static Area createZoomedArea(long seed, int zooms, AreaTransformer0 initialTransformer) {
        LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, seed, seedModifier);
        AreaFactory factory = initialTransformer.run(contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
        factory = LayeredNoiseUtil.zoom(2001L, ZoomLayer.NORMAL, factory, 3, contextFactory);
        factory = LayeredNoiseUtil.zoom(1001L, ZoomLayer.NORMAL, factory, zooms, contextFactory);
        return factory.make();
    }

    public static AreaFactory zoom(long seedModifier, AreaTransformer1 transformer, AreaFactory initialAreaFactory, int times, LongFunction<AreaContext> contextFactory) {
        AreaFactory areaFactory = initialAreaFactory;
        for (int i = 0; i < times; ++i) {
            areaFactory = transformer.run(contextFactory.apply(seedModifier + (long)i), areaFactory);
        }
        return areaFactory;
    }
}

